-- MySQL dump 10.13  Distrib 8.0.37, for Linux (x86_64)
--
-- Host: localhost    Database: ecom
-- ------------------------------------------------------
-- Server version	8.0.37-0ubuntu0.22.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_adobe_ims_webapi`
--

DROP TABLE IF EXISTS `admin_adobe_ims_webapi`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_adobe_ims_webapi` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `access_token_hash` varchar(255) DEFAULT NULL COMMENT 'Access Token Hash',
  `access_token` text COMMENT 'Access Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `last_check_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Last check time',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ADOBE_IMS_WEBAPI_ACCESS_TOKEN_HASH` (`access_token_hash`),
  KEY `ADMIN_ADOBE_IMS_WEBAPI_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `ADMIN_ADOBE_IMS_WEBAPI_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin Adobe IMS Webapi';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_adobe_ims_webapi`
--

LOCK TABLES `admin_adobe_ims_webapi` WRITE;
/*!40000 ALTER TABLE `admin_adobe_ims_webapi` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_adobe_ims_webapi` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_analytics_usage_version_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_analytics_usage_version_log`
--

LOCK TABLES `admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` DISABLE KEYS */;
INSERT INTO `admin_analytics_usage_version_log` VALUES (1,'2.4.6-p4');
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_passwords` (
  `password_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(255) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_PASSWORDS_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_passwords`
--

LOCK TABLES `admin_passwords` WRITE;
/*!40000 ALTER TABLE `admin_passwords` DISABLE KEYS */;
INSERT INTO `admin_passwords` VALUES (1,1,'379ad8260ef8805f4669e9068f1dc0cef0618f08b9c3f2302e97d67cb718ab06:tDpvXgo4lU08XA2BL5cNxo9VDgFm6QYM:3_32_2_67108864',0,1714716392);
/*!40000 ALTER TABLE `admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_system_messages`
--

LOCK TABLES `admin_system_messages` WRITE;
/*!40000 ALTER TABLE `admin_system_messages` DISABLE KEYS */;
INSERT INTO `admin_system_messages` VALUES ('3c5a51dbe9feac32c1f6eef4200f26a0',1,'2024-06-14 06:55:47');
/*!40000 ALTER TABLE `admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user` (
  `user_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES (1,'Admin','User','ajadhav@katalysttech.com','admin','379ad8260ef8805f4669e9068f1dc0cef0618f08b9c3f2302e97d67cb718ab06:tDpvXgo4lU08XA2BL5cNxo9VDgFm6QYM:3_32_2_67108864','2024-05-03 06:06:32','2024-07-02 05:04:32','2024-07-02 05:04:32',101,0,1,'{\"configState\":{\"admin_dashboard\":\"0\",\"system_currency\":\"0\",\"system_security\":\"0\",\"system_cron\":\"1\",\"system_mysqlmq\":\"0\",\"system_smtp\":\"0\",\"system_adminnotification\":\"0\",\"system_backup\":\"0\",\"system_full_page_cache\":\"0\",\"system_bulk\":\"0\",\"system_media_storage_configuration\":\"0\",\"system_upload_configuration\":\"0\",\"system_media_gallery\":\"0\",\"system_media_gallery_renditions\":\"0\",\"system_adobe_stock_integration\":\"0\",\"admin_security\":\"1\",\"admin_emails\":\"0\",\"admin_startup\":\"0\",\"admin_url\":\"0\",\"admin_grid\":\"0\",\"admin_captcha\":\"0\",\"admin_usage\":\"0\",\"web_url\":\"1\",\"web_seo\":\"1\",\"web_unsecure\":\"1\",\"web_secure\":\"1\",\"web_default\":\"1\",\"web_default_layouts\":\"1\",\"web_cookie\":\"1\",\"web_session\":\"1\",\"web_browser_capabilities\":\"1\",\"currency_options\":\"1\",\"currency_fixerio\":\"0\",\"currency_fixerio_apilayer\":\"0\",\"currency_currencyconverterapi\":\"0\",\"currency_import\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL);
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_expiration`
--

DROP TABLE IF EXISTS `admin_user_expiration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user_expiration` (
  `user_id` int unsigned NOT NULL COMMENT 'User ID',
  `expires_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'User Expiration Date',
  PRIMARY KEY (`user_id`),
  CONSTRAINT `ADMIN_USER_EXPIRATION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin User expiration dates table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_expiration`
--

LOCK TABLES `admin_user_expiration` WRITE;
/*!40000 ALTER TABLE `admin_user_expiration` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_user_expiration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user_session` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(1) DEFAULT NULL COMMENT 'Deprecated: Session ID value no longer used',
  `user_id` int unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_USER_SESSION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb3 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_session`
--

LOCK TABLES `admin_user_session` WRITE;
/*!40000 ALTER TABLE `admin_user_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES (1,4,'2024-05-03 06:06:31','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',1,0);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_asset`
--

DROP TABLE IF EXISTS `adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_asset` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` (`media_gallery_id`),
  KEY `ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `ADOBE_STOCK_ASSET_CATEGORY_ID_ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_CREATOR_ID_ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_asset`
--

LOCK TABLES `adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_category`
--

DROP TABLE IF EXISTS `adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_category`
--

LOCK TABLES `adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_creator`
--

DROP TABLE IF EXISTS `adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_creator` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_creator`
--

LOCK TABLES `adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_user_profile`
--

DROP TABLE IF EXISTS `adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_user_profile` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text COMMENT 'Access Token',
  `refresh_token` text COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `ADOBE_USER_PROFILE_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_user_profile`
--

LOCK TABLES `adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_role`
--

DROP TABLE IF EXISTS `authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authorization_role` (
  `role_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_role`
--

LOCK TABLES `authorization_role` WRITE;
/*!40000 ALTER TABLE `authorization_role` DISABLE KEYS */;
INSERT INTO `authorization_role` VALUES (1,0,1,1,'G',0,'2','Administrators'),(2,1,2,0,'U',1,'2','admin'),(3,0,1,0,'U',1,'1','11');
/*!40000 ALTER TABLE `authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_rule`
--

DROP TABLE IF EXISTS `authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authorization_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `AUTHORIZATION_RULE_ROLE_ID_AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6977 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_rule`
--

LOCK TABLES `authorization_rule` WRITE;
/*!40000 ALTER TABLE `authorization_rule` DISABLE KEYS */;
INSERT INTO `authorization_rule` VALUES (1,1,'Magento_Backend::all',NULL,'allow'),(6698,3,'Magento_Backend::all',NULL,'deny'),(6699,3,'Magento_Backend::admin',NULL,'allow'),(6700,3,'Magento_Backend::dashboard',NULL,'deny'),(6701,3,'Magento_Analytics::analytics',NULL,'allow'),(6702,3,'Magento_Analytics::analytics_api',NULL,'allow'),(6703,3,'Magento_Sales::sales',NULL,'deny'),(6704,3,'Magento_Sales::sales_operation',NULL,'deny'),(6705,3,'Magento_Sales::sales_order',NULL,'deny'),(6706,3,'Magento_Sales::actions',NULL,'deny'),(6707,3,'Magento_Sales::create',NULL,'deny'),(6708,3,'Magento_Sales::actions_view',NULL,'deny'),(6709,3,'Magento_Sales::email',NULL,'deny'),(6710,3,'Magento_Sales::reorder',NULL,'deny'),(6711,3,'Magento_Sales::actions_edit',NULL,'deny'),(6712,3,'Magento_Sales::cancel',NULL,'deny'),(6713,3,'Magento_Sales::review_payment',NULL,'deny'),(6714,3,'Magento_Sales::capture',NULL,'deny'),(6715,3,'Magento_Sales::invoice',NULL,'deny'),(6716,3,'Magento_Sales::creditmemo',NULL,'deny'),(6717,3,'Magento_Sales::hold',NULL,'deny'),(6718,3,'Magento_Sales::unhold',NULL,'deny'),(6719,3,'Magento_Sales::ship',NULL,'deny'),(6720,3,'Magento_Sales::comment',NULL,'deny'),(6721,3,'Magento_Sales::emails',NULL,'deny'),(6722,3,'Magento_Paypal::authorization',NULL,'deny'),(6723,3,'Magento_Sales::sales_invoice',NULL,'deny'),(6724,3,'Magento_Sales::shipment',NULL,'deny'),(6725,3,'Magento_Sales::sales_creditmemo',NULL,'deny'),(6726,3,'Magento_Paypal::billing_agreement',NULL,'deny'),(6727,3,'Magento_Paypal::billing_agreement_actions',NULL,'deny'),(6728,3,'Magento_Paypal::billing_agreement_actions_view',NULL,'deny'),(6729,3,'Magento_Paypal::actions_manage',NULL,'deny'),(6730,3,'Magento_Paypal::use',NULL,'deny'),(6731,3,'Magento_Sales::transactions',NULL,'deny'),(6732,3,'Magento_Sales::transactions_fetch',NULL,'deny'),(6733,3,'Magento_Catalog::catalog',NULL,'deny'),(6734,3,'Magento_Catalog::catalog_inventory',NULL,'deny'),(6735,3,'Magento_Catalog::products',NULL,'deny'),(6736,3,'Magento_Catalog::update_attributes',NULL,'deny'),(6737,3,'Magento_Catalog::edit_product_design',NULL,'deny'),(6738,3,'Magento_Catalog::categories',NULL,'deny'),(6739,3,'Magento_Catalog::edit_category_design',NULL,'deny'),(6740,3,'Katalyst_Price::price',NULL,'deny'),(6741,3,'Katalyst_Shirt::shirt',NULL,'deny'),(6742,3,'Katalyst_Thread::thread',NULL,'deny'),(6743,3,'Suit_LapelColor::color',NULL,'deny'),(6744,3,'Suit_Lining::lining',NULL,'deny'),(6745,3,'Suit_Price::price',NULL,'deny'),(6746,3,'Suit_SuitTool::suit_suittool',NULL,'deny'),(6747,3,'Suit_Tie::tie',NULL,'deny'),(6748,3,'Vest_LapelColor::color',NULL,'deny'),(6749,3,'Vest_Lining::lining',NULL,'deny'),(6750,3,'Vest_Price::price',NULL,'deny'),(6751,3,'Vest_SuitTool::suit_suittool',NULL,'deny'),(6752,3,'Vest_Tie::tie',NULL,'deny'),(6753,3,'Magento_Customer::customer',NULL,'deny'),(6754,3,'Magento_Customer::manage',NULL,'deny'),(6755,3,'Magento_Customer::actions',NULL,'deny'),(6756,3,'Magento_Customer::delete',NULL,'deny'),(6757,3,'Magento_Customer::reset_password',NULL,'deny'),(6758,3,'Magento_Customer::invalidate_tokens',NULL,'deny'),(6759,3,'Magento_LoginAsCustomer::allow_shopping_assistance',NULL,'deny'),(6760,3,'Magento_Customer::online',NULL,'deny'),(6761,3,'Magento_Customer::group',NULL,'deny'),(6762,3,'Magento_LoginAsCustomer::login',NULL,'deny'),(6763,3,'Magento_LoginAsCustomerLog::login_log',NULL,'deny'),(6764,3,'Magento_Cart::cart',NULL,'deny'),(6765,3,'Magento_Cart::manage',NULL,'deny'),(6766,3,'Katalyst_Base::base',NULL,'deny'),(6767,3,'Magento_Backend::myaccount',NULL,'deny'),(6768,3,'Magento_Backend::marketing',NULL,'deny'),(6769,3,'Magento_CatalogRule::promo',NULL,'deny'),(6770,3,'Magento_CatalogRule::promo_catalog',NULL,'deny'),(6771,3,'Magento_SalesRule::quote',NULL,'deny'),(6772,3,'Magento_Backend::marketing_communications',NULL,'deny'),(6773,3,'Magento_Email::template',NULL,'deny'),(6774,3,'Magento_Newsletter::template',NULL,'deny'),(6775,3,'Magento_Newsletter::queue',NULL,'deny'),(6776,3,'Magento_Newsletter::subscriber',NULL,'deny'),(6777,3,'Magento_Backend::marketing_seo',NULL,'deny'),(6778,3,'Magento_Search::search',NULL,'deny'),(6779,3,'Magento_Search::synonyms',NULL,'deny'),(6780,3,'Magento_UrlRewrite::urlrewrite',NULL,'deny'),(6781,3,'Magento_Sitemap::sitemap',NULL,'deny'),(6782,3,'Magento_Backend::marketing_user_content',NULL,'deny'),(6783,3,'Magento_Review::reviews_all',NULL,'deny'),(6784,3,'Magento_Review::pending',NULL,'deny'),(6785,3,'Magento_Backend::content',NULL,'deny'),(6786,3,'Magento_Backend::content_elements',NULL,'deny'),(6787,3,'Magento_Cms::page',NULL,'deny'),(6788,3,'Magento_Cms::save',NULL,'deny'),(6789,3,'Magento_Cms::save_design',NULL,'deny'),(6790,3,'Magento_Cms::page_delete',NULL,'deny'),(6791,3,'Magento_Cms::block',NULL,'deny'),(6792,3,'Magento_Widget::widget_instance',NULL,'deny'),(6793,3,'Magento_Cms::media_gallery',NULL,'deny'),(6794,3,'Magento_MediaGalleryUiApi::insert_assets',NULL,'deny'),(6795,3,'Magento_MediaGalleryUiApi::upload_assets',NULL,'deny'),(6796,3,'Magento_MediaGalleryUiApi::edit_assets',NULL,'deny'),(6797,3,'Magento_AdobeStockImageAdminUi::media_gallery',NULL,'deny'),(6798,3,'Magento_AdobeStockImageAdminUi::save_preview_images',NULL,'deny'),(6799,3,'Magento_AdobeStockImageAdminUi::license_images',NULL,'deny'),(6800,3,'Magento_MediaGalleryUiApi::delete_assets',NULL,'deny'),(6801,3,'Magento_MediaGalleryUiApi::create_folder',NULL,'deny'),(6802,3,'Magento_MediaGalleryUiApi::delete_folder',NULL,'deny'),(6803,3,'Magento_PageBuilder::templates',NULL,'deny'),(6804,3,'Magento_PageBuilder::template_save',NULL,'deny'),(6805,3,'Magento_PageBuilder::template_apply',NULL,'deny'),(6806,3,'Magento_PageBuilder::template_delete',NULL,'deny'),(6807,3,'Magento_Backend::design',NULL,'deny'),(6808,3,'Magento_Theme::theme',NULL,'deny'),(6809,3,'Magento_Backend::schedule',NULL,'deny'),(6810,3,'Magento_Backend::content_translation',NULL,'deny'),(6811,3,'Magento_Reports::report',NULL,'deny'),(6812,3,'Magento_Reports::report_marketing',NULL,'deny'),(6813,3,'Magento_Reports::shopcart',NULL,'deny'),(6814,3,'Magento_Reports::product',NULL,'deny'),(6815,3,'Magento_Reports::abandoned',NULL,'deny'),(6816,3,'Magento_Reports::report_search',NULL,'deny'),(6817,3,'Magento_Newsletter::problem',NULL,'deny'),(6818,3,'Magento_Reports::review',NULL,'deny'),(6819,3,'Magento_Reports::review_customer',NULL,'deny'),(6820,3,'Magento_Reports::review_product',NULL,'deny'),(6821,3,'Magento_Reports::salesroot',NULL,'deny'),(6822,3,'Magento_Reports::salesroot_sales',NULL,'deny'),(6823,3,'Magento_Reports::tax',NULL,'deny'),(6824,3,'Magento_Reports::invoiced',NULL,'deny'),(6825,3,'Magento_Reports::shipping',NULL,'deny'),(6826,3,'Magento_Reports::refunded',NULL,'deny'),(6827,3,'Magento_Reports::coupons',NULL,'deny'),(6828,3,'Magento_Paypal::paypal_settlement_reports',NULL,'deny'),(6829,3,'Magento_Paypal::paypal_settlement_reports_view',NULL,'deny'),(6830,3,'Magento_Paypal::fetch',NULL,'deny'),(6831,3,'PayPal_Braintree::settlement_report',NULL,'deny'),(6832,3,'Magento_Reports::customers',NULL,'deny'),(6833,3,'Magento_Reports::totals',NULL,'deny'),(6834,3,'Magento_Reports::customers_orders',NULL,'deny'),(6835,3,'Magento_Reports::accounts',NULL,'deny'),(6836,3,'Magento_Reports::report_products',NULL,'deny'),(6837,3,'Magento_Reports::viewed',NULL,'deny'),(6838,3,'Magento_Reports::bestsellers',NULL,'deny'),(6839,3,'Magento_Reports::lowstock',NULL,'deny'),(6840,3,'Magento_Reports::sold',NULL,'deny'),(6841,3,'Magento_Reports::downloads',NULL,'deny'),(6842,3,'Magento_Reports::statistics',NULL,'deny'),(6843,3,'Magento_Reports::statistics_refresh',NULL,'deny'),(6844,3,'Magento_Analytics::business_intelligence',NULL,'deny'),(6845,3,'Magento_Analytics::advanced_reporting',NULL,'deny'),(6846,3,'Magento_Analytics::bi_essentials',NULL,'deny'),(6847,3,'Magento_Backend::stores',NULL,'deny'),(6848,3,'Magento_Backend::stores_settings',NULL,'deny'),(6849,3,'Magento_Backend::store',NULL,'deny'),(6850,3,'Magento_Config::config',NULL,'deny'),(6851,3,'Magento_Cms::config_cms',NULL,'deny'),(6852,3,'Magento_Catalog::config_catalog',NULL,'deny'),(6853,3,'Magento_CatalogSearch::config_catalog_search',NULL,'deny'),(6854,3,'Magento_CatalogInventory::cataloginventory',NULL,'deny'),(6855,3,'Magento_Payment::payment',NULL,'deny'),(6856,3,'Magento_Payment::payment_services',NULL,'deny'),(6857,3,'Magento_Contact::contact',NULL,'deny'),(6858,3,'Magento_Downloadable::downloadable',NULL,'deny'),(6859,3,'Magento_GoogleAnalytics::google',NULL,'deny'),(6860,3,'Magento_LoginAsCustomer::config_section',NULL,'deny'),(6861,3,'Magento_Newsletter::newsletter',NULL,'deny'),(6862,3,'Magento_Shipping::carriers',NULL,'deny'),(6863,3,'Magento_InventoryInStorePickupApi::inStorePickup',NULL,'deny'),(6864,3,'Magento_InventoryInStorePickupApi::notify_orders_are_ready_for_pickup',NULL,'deny'),(6865,3,'Magento_Shipping::config_shipping',NULL,'deny'),(6866,3,'Magento_Shipping::shipping_policy',NULL,'deny'),(6867,3,'Magento_Multishipping::config_multishipping',NULL,'deny'),(6868,3,'Magento_ReCaptchaUi::config',NULL,'deny'),(6869,3,'Magento_Securitytxt::config',NULL,'deny'),(6870,3,'Magento_Config::config_general',NULL,'deny'),(6871,3,'Magento_Integration::config_oauth',NULL,'deny'),(6872,3,'Magento_Webapi::config_webapi',NULL,'deny'),(6873,3,'Magento_Config::web',NULL,'deny'),(6874,3,'Magento_Config::config_design',NULL,'deny'),(6875,3,'Magento_Customer::config_customer',NULL,'deny'),(6876,3,'Magento_Paypal::paypal',NULL,'deny'),(6877,3,'Magento_Tax::config_tax',NULL,'deny'),(6878,3,'Magento_Checkout::checkout',NULL,'deny'),(6879,3,'Magento_Sales::config_sales',NULL,'deny'),(6880,3,'Magento_Persistent::persistent',NULL,'deny'),(6881,3,'Magento_Sales::sales_email',NULL,'deny'),(6882,3,'Magento_Sales::sales_pdf',NULL,'deny'),(6883,3,'Magento_Reports::reports',NULL,'deny'),(6884,3,'Magento_Sitemap::config_sitemap',NULL,'deny'),(6885,3,'Magento_Config::config_system',NULL,'deny'),(6886,3,'Magento_Wishlist::config_wishlist',NULL,'deny'),(6887,3,'Magento_SalesRule::config_promo',NULL,'deny'),(6888,3,'Magento_Config::config_admin',NULL,'deny'),(6889,3,'Magento_Config::trans_email',NULL,'deny'),(6890,3,'Magento_Config::dev',NULL,'deny'),(6891,3,'Magento_Config::currency',NULL,'deny'),(6892,3,'Magento_Rss::rss',NULL,'deny'),(6893,3,'Magento_Config::sendfriend',NULL,'deny'),(6894,3,'Magento_Analytics::analytics_settings',NULL,'deny'),(6895,3,'Magento_NewRelicReporting::config_newrelicreporting',NULL,'deny'),(6896,3,'Magento_CheckoutAgreements::checkoutagreement',NULL,'deny'),(6897,3,'Magento_Sales::order_statuses',NULL,'deny'),(6898,3,'Magento_InventoryApi::inventory',NULL,'deny'),(6899,3,'Magento_InventoryApi::source',NULL,'deny'),(6900,3,'Magento_InventoryApi::source_edit',NULL,'deny'),(6901,3,'Magento_InventoryApi::ship_source_selection',NULL,'deny'),(6902,3,'Magento_InventorySourceSelectionApi::source_selection_algorithm',NULL,'deny'),(6903,3,'Magento_InventorySourceSelectionApi::source_selection_algorithm_post',NULL,'deny'),(6904,3,'Magento_InventoryApi::stock',NULL,'deny'),(6905,3,'Magento_InventoryApi::stock_edit',NULL,'deny'),(6906,3,'Magento_InventoryApi::stock_delete',NULL,'deny'),(6907,3,'Magento_InventoryLowQuantityNotificationApi::low_quantity_notification',NULL,'deny'),(6908,3,'Magento_InventoryLowQuantityNotificationApi::stock_create_low_quantity_notification',NULL,'deny'),(6909,3,'Magento_InventoryLowQuantityNotificationApi::stock_delete_low_quantity_notification',NULL,'deny'),(6910,3,'Magento_InventoryApi::stock_source_link',NULL,'deny'),(6911,3,'Magento_InventoryApi::stock_source_item_assign',NULL,'deny'),(6912,3,'Magento_InventorySalesApi::stock',NULL,'deny'),(6913,3,'Magento_Tax::manage_tax',NULL,'deny'),(6914,3,'Magento_CurrencySymbol::system_currency',NULL,'deny'),(6915,3,'Magento_CurrencySymbol::currency_rates',NULL,'deny'),(6916,3,'Magento_CurrencySymbol::symbols',NULL,'deny'),(6917,3,'Magento_Backend::stores_attributes',NULL,'deny'),(6918,3,'Magento_Catalog::attributes_attributes',NULL,'deny'),(6919,3,'Magento_Catalog::sets',NULL,'deny'),(6920,3,'Magento_Review::ratings',NULL,'deny'),(6921,3,'Magento_Swatches::iframe',NULL,'deny'),(6922,3,'Magento_Backend::stores_other_settings',NULL,'deny'),(6923,3,'Magento_Backend::system',NULL,'deny'),(6924,3,'Magento_AdobeIms::adobe_ims',NULL,'deny'),(6925,3,'Magento_AdobeIms::actions',NULL,'deny'),(6926,3,'Magento_AdobeIms::login',NULL,'deny'),(6927,3,'Magento_AdobeIms::logout',NULL,'deny'),(6928,3,'Magento_AdobeStockAsset::adobe_stock_asset',NULL,'deny'),(6929,3,'Magento_AdobeStockAsset::actions',NULL,'deny'),(6930,3,'Magento_AdobeStockAsset::actions_delete',NULL,'deny'),(6931,3,'Magento_AdobeStockAsset::actions_save',NULL,'deny'),(6932,3,'Magento_AdobeStockAsset::actions_view',NULL,'deny'),(6933,3,'Magento_AdobeStockAsset::actions_get',NULL,'deny'),(6934,3,'Magento_Backend::convert',NULL,'deny'),(6935,3,'Magento_ImportExport::import',NULL,'deny'),(6936,3,'Magento_ImportExport::export',NULL,'deny'),(6937,3,'Magento_TaxImportExport::import_export',NULL,'deny'),(6938,3,'Magento_ImportExport::history',NULL,'deny'),(6939,3,'Magento_Backend::extensions',NULL,'deny'),(6940,3,'Magento_Backend::local',NULL,'deny'),(6941,3,'Magento_Backend::custom',NULL,'deny'),(6942,3,'Magento_Integration::extensions',NULL,'deny'),(6943,3,'Magento_Integration::integrations',NULL,'deny'),(6944,3,'Magento_Backend::tools',NULL,'deny'),(6945,3,'Magento_Backend::cache',NULL,'deny'),(6946,3,'Magento_Backend::main_actions',NULL,'deny'),(6947,3,'Magento_Backend::flush_cache_storage',NULL,'deny'),(6948,3,'Magento_Backend::flush_magento_cache',NULL,'deny'),(6949,3,'Magento_Backend::mass_actions',NULL,'deny'),(6950,3,'Magento_Backend::toggling_cache_type',NULL,'deny'),(6951,3,'Magento_Backend::refresh_cache_type',NULL,'deny'),(6952,3,'Magento_Backend::additional_cache_management',NULL,'deny'),(6953,3,'Magento_Backend::flush_catalog_images',NULL,'deny'),(6954,3,'Magento_Backend::flush_js_css',NULL,'deny'),(6955,3,'Magento_Backend::flush_static_files',NULL,'deny'),(6956,3,'Magento_Backup::backup',NULL,'deny'),(6957,3,'Magento_Backup::rollback',NULL,'deny'),(6958,3,'Magento_Indexer::index',NULL,'deny'),(6959,3,'Magento_Indexer::changeMode',NULL,'deny'),(6960,3,'Magento_Indexer::invalidate',NULL,'deny'),(6961,3,'Magento_User::acl',NULL,'deny'),(6962,3,'Magento_User::acl_users',NULL,'deny'),(6963,3,'Magento_User::locks',NULL,'deny'),(6964,3,'Magento_User::acl_roles',NULL,'deny'),(6965,3,'Magento_Logging::magento_logging',NULL,'deny'),(6966,3,'Magento_Logging::magento_logging_events',NULL,'deny'),(6967,3,'Magento_Logging::system_magento_logging_bulk_operations',NULL,'deny'),(6968,3,'Magento_Backend::system_other_settings',NULL,'deny'),(6969,3,'Magento_AdminNotification::adminnotification',NULL,'deny'),(6970,3,'Magento_AdminNotification::show_toolbar',NULL,'deny'),(6971,3,'Magento_AdminNotification::show_list',NULL,'deny'),(6972,3,'Magento_AdminNotification::mark_as_read',NULL,'deny'),(6973,3,'Magento_AdminNotification::adminnotification_remove',NULL,'deny'),(6974,3,'Magento_Variable::variable',NULL,'deny'),(6975,3,'Magento_EncryptionKey::crypt_key',NULL,'deny'),(6976,3,'Magento_Backend::global_search',NULL,'deny');
/*!40000 ALTER TABLE `authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backcollar`
--

DROP TABLE IF EXISTS `backcollar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `backcollar` (
  `backcollar_id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(40) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `class` varchar(100) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `glow_image` varchar(255) DEFAULT NULL,
  `mask_image` varchar(255) DEFAULT NULL,
  `status` smallint NOT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`backcollar_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backcollar`
--

LOCK TABLES `backcollar` WRITE;
/*!40000 ALTER TABLE `backcollar` DISABLE KEYS */;
INSERT INTO `backcollar` VALUES (1,'With collar',10.00,'suit-icon-Custom_Colour','glow_mask/backcollar/01_Neck_Lining.png','glow_mask/backcollar/necklining_glow.png','glow_mask/backcollar/necklining_mask.png',1,'2017-12-30 05:42:37','2019-07-01 09:44:37'),(2,'Without collar',10.00,'suit-icon-No','glow_mask/backcollar/without_necklining.png','','',1,'2017-12-30 05:44:15','2019-07-01 09:45:42');
/*!40000 ALTER TABLE `backcollar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `braintree_credit_prices`
--

DROP TABLE IF EXISTS `braintree_credit_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `braintree_credit_prices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Row ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product Id',
  `term` int NOT NULL COMMENT 'Credit Term',
  `monthly_payment` decimal(12,2) NOT NULL COMMENT 'Monthly Payment',
  `instalment_rate` decimal(12,2) NOT NULL COMMENT 'Instalment Rate',
  `cost_of_purchase` decimal(12,2) NOT NULL COMMENT 'Cost of purchase',
  `total_inc_interest` decimal(12,2) NOT NULL COMMENT 'Total Inc Interest',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID_TERM` (`product_id`,`term`),
  KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Braintree credit rates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `braintree_credit_prices`
--

LOCK TABLES `braintree_credit_prices` WRITE;
/*!40000 ALTER TABLE `braintree_credit_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `braintree_credit_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `braintree_transaction_details`
--

DROP TABLE IF EXISTS `braintree_transaction_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `braintree_transaction_details` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order Id',
  `transaction_source` varchar(12) DEFAULT NULL COMMENT 'Transaction Source',
  PRIMARY KEY (`entity_id`),
  KEY `BRAINTREE_TRANSACTION_DETAILS_ORDER_ID` (`order_id`),
  CONSTRAINT `BRAINTREE_TRANSACTION_DETAILS_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Braintree transaction details table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `braintree_transaction_details`
--

LOCK TABLES `braintree_transaction_details` WRITE;
/*!40000 ALTER TABLE `braintree_transaction_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `braintree_transaction_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_tag`
--

DROP TABLE IF EXISTS `cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_tag`
--

LOCK TABLES `cache_tag` WRITE;
/*!40000 ALTER TABLE `cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  `count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `captcha_log`
--

LOCK TABLES `captcha_log` WRITE;
/*!40000 ALTER TABLE `captcha_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int NOT NULL COMMENT 'Position',
  `level` int NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES (1,3,0,'2024-05-03 06:06:28','2024-05-03 06:06:29','1',0,0,1),(2,3,1,'2024-05-03 06:06:29','2024-05-03 06:06:29','1/2',1,1,0);
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_datetime`
--

LOCK TABLES `catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_decimal`
--

LOCK TABLES `catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_INT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES (1,69,0,1,1),(2,69,0,2,1),(3,46,0,2,1);
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_text`
--

LOCK TABLES `catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_text` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES (1,45,0,1,'Root Catalog'),(2,52,0,2,'PRODUCTS'),(3,45,0,2,'Default Category');
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product` (
  `entity_id` int NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_CTGR_PRD_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES (1,2,1,0);
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_replica`
--

LOCK TABLES `catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store1`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store1` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE1_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_216E521C8AD125E066D2B0BAB4A08412` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store1`
--

LOCK TABLES `catalog_category_product_index_store1` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store1` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store1` VALUES (2,2,10000,0,1,4),(2,1,0,1,1,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store1_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store1_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_4B965DC45C352D6E4C9DC0FF50B1FCF5` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_47AB760CD6A893ACEA69A9C2E0112C60` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store1 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store1_replica`
--

LOCK TABLES `catalog_category_product_index_store1_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store1_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store1_replica` VALUES (2,1,0,1,1,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store1_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Indexer temporary table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_tmp`
--

LOCK TABLES `catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `list_id` int unsigned DEFAULT NULL COMMENT 'List ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `CATALOG_COMPARE_ITEM_LIST_ID_CATALOG_COMPARE_LIST_LIST_ID` (`list_id`),
  KEY `CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_COMPARE_ITEM_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_LIST_ID_CATALOG_COMPARE_LIST_LIST_ID` FOREIGN KEY (`list_id`) REFERENCES `catalog_compare_list` (`list_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_compare_item`
--

LOCK TABLES `catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `catalog_compare_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_list`
--

DROP TABLE IF EXISTS `catalog_compare_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_compare_list` (
  `list_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare List ID',
  `list_id_mask` varchar(32) DEFAULT NULL COMMENT 'Masked ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`list_id`),
  UNIQUE KEY `CATALOG_COMPARE_LIST_CUSTOMER_ID` (`customer_id`),
  KEY `CATALOG_COMPARE_LIST_LIST_ID_MASK` (`list_id_mask`),
  CONSTRAINT `CATALOG_COMPARE_LIST_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Compare List with hash Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_compare_list`
--

LOCK TABLES `catalog_compare_list` WRITE;
/*!40000 ALTER TABLE `catalog_compare_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_compare_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `is_pagebuilder_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is PageBuilder Enabled',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `CATALOG_EAV_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_eav_attribute`
--

LOCK TABLES `catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,0,NULL),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(64,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,0,0,0,0,0,0,0,5,0,NULL),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,0,0,0,0,0,0,0,6,0,NULL),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,0,1,0,0,0,0,0,1,1,NULL),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,0,1,0,0,1,0,0,1,0,NULL),(77,NULL,1,1,1,1,0,0,0,0,0,1,1,'simple,virtual,downloadable,bundle,configurable',1,0,0,0,0,0,0,0,1,0,NULL),(78,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,0,1,0,NULL),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,0,1,0,NULL),(81,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,0,0,0,0,1,0,1,1,0,NULL),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(83,NULL,1,1,1,1,1,0,0,0,0,0,0,'simple,configurable',1,0,0,0,0,1,0,1,1,0,NULL),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable,bundle',0,0,0,0,0,0,0,0,1,0,NULL),(93,NULL,1,1,1,1,1,0,0,0,0,0,0,'simple,virtual,configurable',1,0,0,0,0,1,0,1,1,0,NULL),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,1,0,0,0,1,0,NULL),(98,NULL,0,0,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,0,0,0,1,0,NULL),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,1,0,0,0,1,0,NULL),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(103,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,grouped,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(118,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(119,NULL,0,1,1,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(120,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(121,NULL,0,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(122,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(123,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(124,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,0,0,0,1,0,NULL),(125,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(126,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(127,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(128,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(129,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(130,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(131,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(132,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(133,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(134,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(135,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(136,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(137,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(138,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL);
/*!40000 ALTER TABLE `catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `required` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option`
--

LOCK TABLES `catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_VAL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option_value`
--

LOCK TABLES `catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `min_price` decimal(20,6) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_price_index`
--

LOCK TABLES `catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection`
--

LOCK TABLES `catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int unsigned NOT NULL COMMENT 'Selection ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Selection Price Value',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_DCF37523AA05D770A70AA4ED7C2616E4` FOREIGN KEY (`selection_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection_price`
--

LOCK TABLES `catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `stock_status` smallint DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_stock_index`
--

LOCK TABLES `catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) NOT NULL COMMENT 'SKU',
  `has_options` smallint NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity`
--

LOCK TABLES `catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity` VALUES (1,4,'simple','Test',0,0,'2024-05-09 09:27:35','2024-05-09 09:33:51'),(2,4,'simple','Shirt',0,0,'2024-06-19 05:57:00','2024-06-19 05:57:33');
/*!40000 ALTER TABLE `catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_datetime`
--

LOCK TABLES `catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_datetime` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CAT_PRD_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DEC_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_decimal`
--

LOCK TABLES `catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_decimal` VALUES (1,77,0,1,100.000000),(2,77,0,2,100.000000);
/*!40000 ALTER TABLE `catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_gallery` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_GLR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_gallery`
--

LOCK TABLES `catalog_product_entity_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_int`
--

DROP TABLE IF EXISTS `catalog_product_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID_STORE_ID_VALUE` (`attribute_id`,`store_id`,`value`),
  CONSTRAINT `CAT_PRD_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_INT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_int`
--

LOCK TABLES `catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_int` VALUES (1,138,0,1,1),(2,137,0,1,1),(3,97,0,1,1),(4,136,0,1,2),(5,99,0,1,4),(6,138,0,2,1),(7,137,0,2,1),(8,97,0,2,1),(9,136,0,2,2),(10,99,0,2,4);
/*!40000 ALTER TABLE `catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  `media_type` varchar(32) NOT NULL DEFAULT 'image' COMMENT 'Media entry type',
  `disabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility status',
  PRIMARY KEY (`value_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Media Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery`
--

LOCK TABLES `catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery_value` (
  `value_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  `record_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  PRIMARY KEY (`record_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_VALUE_ID` (`value_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_VAL_ID_STORE_ID` (`entity_id`,`value_id`,`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_VAL_ID_CAT_PRD_ENTT_MDA_GLR_VAL_ID` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Media Gallery Attribute Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value`
--

LOCK TABLES `catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_to_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_to_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery_value_to_entity` (
  `value_id` int unsigned NOT NULL COMMENT 'Value media Entry ID',
  `entity_id` int unsigned NOT NULL COMMENT 'Product Entity ID',
  PRIMARY KEY (`value_id`,`entity_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` (`entity_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A6C6C8FAA386736921D3A7C4B50B1185` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Link Media value to Product entity table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value_to_entity`
--

LOCK TABLES `catalog_product_entity_media_gallery_value_to_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_video`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery_value_video` (
  `value_id` int unsigned NOT NULL COMMENT 'Media Entity ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `provider` varchar(32) DEFAULT NULL COMMENT 'Video provider ID',
  `url` text COMMENT 'Video URL',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Page Meta Description',
  `metadata` text COMMENT 'Video meta data',
  PRIMARY KEY (`value_id`,`store_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_6FDF205946906B0E653E60AA769899F8` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Video Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value_video`
--

LOCK TABLES `catalog_product_entity_media_gallery_value_video` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_video` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_video` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_text`
--

DROP TABLE IF EXISTS `catalog_product_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TEXT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_text`
--

LOCK TABLES `catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_text` VALUES (1,85,0,1,'Test'),(2,85,0,2,'Shirt');
/*!40000 ALTER TABLE `catalog_product_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_entity_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_tier_price` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `all_groups` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Applicable To All Customer Groups',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'QTY',
  `value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Value',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `percentage_value` decimal(5,2) DEFAULT NULL COMMENT 'Percentage value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_E8AB433B9ACB00343ABB312AD2FAB087` (`entity_id`,`all_groups`,`customer_group_id`,`qty`,`website_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TIER_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_ENTT_TIER_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TIER_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Tier Price Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_tier_price`
--

LOCK TABLES `catalog_product_entity_tier_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_tier_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_tier_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_product_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_VCHR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_varchar`
--

LOCK TABLES `catalog_product_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_varchar` VALUES (1,134,0,1,'2'),(2,86,0,1,'Test '),(3,84,0,1,'Test'),(4,124,0,1,'0'),(5,73,0,1,'Test'),(6,106,0,1,'container2'),(7,104,0,1,'product-full-width'),(8,121,0,1,'test'),(9,134,0,2,'2'),(10,86,0,2,'Shirt '),(11,84,0,2,'Shirt'),(12,124,0,2,'0'),(13,73,0,2,'Shirt'),(14,106,0,2,'container2'),(15,104,0,2,'product-full-width'),(16,121,0,2,'shirt');
/*!40000 ALTER TABLE `catalog_product_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_frontend_action`
--

DROP TABLE IF EXISTS `catalog_product_frontend_action`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_frontend_action` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Action ID',
  `type_id` varchar(64) NOT NULL COMMENT 'Type of product action',
  `visitor_id` int unsigned DEFAULT NULL COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `added_at` bigint NOT NULL COMMENT 'Added At',
  PRIMARY KEY (`action_id`),
  UNIQUE KEY `CATALOG_PRODUCT_FRONTEND_ACTION_VISITOR_ID_PRODUCT_ID_TYPE_ID` (`visitor_id`,`product_id`,`type_id`),
  UNIQUE KEY `CATALOG_PRODUCT_FRONTEND_ACTION_CUSTOMER_ID_PRODUCT_ID_TYPE_ID` (`customer_id`,`product_id`,`type_id`),
  KEY `CAT_PRD_FRONTEND_ACTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_FRONTEND_ACTION_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_FRONTEND_ACTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Frontend Action Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_frontend_action`
--

LOCK TABLES `catalog_product_frontend_action` WRITE;
/*!40000 ALTER TABLE `catalog_product_frontend_action` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_frontend_action` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav`
--

DROP TABLE IF EXISTS `catalog_product_index_eav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav`
--

LOCK TABLES `catalog_product_index_eav` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav` VALUES (1,99,1,4,1),(2,99,1,4,2);
/*!40000 ALTER TABLE `catalog_product_index_eav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal`
--

LOCK TABLES `catalog_product_index_eav_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal_idx`
--

LOCK TABLES `catalog_product_index_eav_decimal_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal_replica`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal_replica` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal_replica`
--

LOCK TABLES `catalog_product_index_eav_decimal_replica` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal_tmp`
--

LOCK TABLES `catalog_product_index_eav_decimal_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_idx`
--

LOCK TABLES `catalog_product_index_eav_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_replica`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_replica` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_replica`
--

LOCK TABLES `catalog_product_index_eav_replica` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_replica` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav_replica` VALUES (1,99,1,4,1);
/*!40000 ALTER TABLE `catalog_product_index_eav_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_tmp`
--

LOCK TABLES `catalog_product_index_eav_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price`
--

DROP TABLE IF EXISTS `catalog_product_index_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_MIN_PRICE` (`min_price`),
  KEY `CAT_PRD_IDX_PRICE_WS_ID_CSTR_GROUP_ID_MIN_PRICE` (`website_id`,`customer_group_id`,`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price`
--

LOCK TABLES `catalog_product_index_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price` VALUES (1,0,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(1,1,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(1,2,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(1,3,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(2,0,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(2,1,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(2,2,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(2,3,1,2,100.000000,100.000000,100.000000,100.000000,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price_type` smallint unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(20,6) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(20,6) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Opt Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_opt_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Opt Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `selection_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Selection ID',
  `group_type` smallint unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Sel Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_sel_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_sel_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `selection_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Selection ID',
  `group_type` smallint unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Sel Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_sel_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_sel_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price_type` smallint unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(20,6) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(20,6) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_idx` (
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Aggregate Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_agr_idx`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_agr_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_tmp` (
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Aggregate Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_agr_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_idx`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_downlod_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_downlod_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Minimum price',
  `max_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Indexer Table for price of downloadable products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_downlod_idx`
--

LOCK TABLES `catalog_product_index_price_downlod_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_downlod_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_downlod_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Minimum price',
  `max_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Temporary Indexer Table for price of downloadable products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_downlod_tmp`
--

LOCK TABLES `catalog_product_index_price_downlod_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_final_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_final_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Final Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_final_idx`
--

LOCK TABLES `catalog_product_index_price_final_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_final_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_final_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_final_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_final_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Final Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_final_tmp`
--

LOCK TABLES `catalog_product_index_price_final_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_final_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_final_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_MIN_PRICE` (`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_idx`
--

LOCK TABLES `catalog_product_index_price_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_agr_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Aggregate Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_agr_idx`
--

LOCK TABLES `catalog_product_index_price_opt_agr_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_agr_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Aggregate Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_agr_tmp`
--

LOCK TABLES `catalog_product_index_price_opt_agr_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_idx`
--

LOCK TABLES `catalog_product_index_price_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_replica`
--

DROP TABLE IF EXISTS `catalog_product_index_price_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_replica` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_MIN_PRICE` (`min_price`),
  KEY `CAT_PRD_IDX_PRICE_WS_ID_CSTR_GROUP_ID_MIN_PRICE` (`website_id`,`customer_group_id`,`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_replica`
--

LOCK TABLES `catalog_product_index_price_replica` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_replica` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_replica` VALUES (1,0,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(1,1,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(1,2,1,2,100.000000,100.000000,100.000000,100.000000,NULL),(1,3,1,2,100.000000,100.000000,100.000000,100.000000,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Product ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_tmp`
--

LOCK TABLES `catalog_product_index_price_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_index_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_tier_price` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_TIER_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_IDX_TIER_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_IDX_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_IDX_TIER_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Tier Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_tier_price`
--

LOCK TABLES `catalog_product_index_tier_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_tier_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_tier_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_website`
--

DROP TABLE IF EXISTS `catalog_product_index_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_website` (
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `default_store_id` smallint unsigned NOT NULL COMMENT 'Default store ID for website',
  `website_date` date DEFAULT NULL COMMENT 'Website Date',
  `rate` float DEFAULT '1' COMMENT 'Rate',
  PRIMARY KEY (`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_WEBSITE_WEBSITE_DATE` (`website_date`),
  CONSTRAINT `CAT_PRD_IDX_WS_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Website Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_website`
--

LOCK TABLES `catalog_product_index_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_website` DISABLE KEYS */;
INSERT INTO `catalog_product_index_website` VALUES (1,1,'2024-06-19',1);
/*!40000 ALTER TABLE `catalog_product_index_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link`
--

DROP TABLE IF EXISTS `catalog_product_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `linked_product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Linked Product ID',
  `link_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `CATALOG_PRODUCT_LINK_LINK_TYPE_ID_PRODUCT_ID_LINKED_PRODUCT_ID` (`link_type_id`,`product_id`,`linked_product_id`),
  KEY `CATALOG_PRODUCT_LINK_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_PRODUCT_LINK_LINKED_PRODUCT_ID` (`linked_product_id`),
  CONSTRAINT `CAT_PRD_LNK_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_LNK_LNKED_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`linked_product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_LINK_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product To Product Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link`
--

LOCK TABLES `catalog_product_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute` (
  `product_link_attribute_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Link Attribute ID',
  `link_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  `product_link_attribute_code` varchar(32) DEFAULT NULL COMMENT 'Product Link Attribute Code',
  `data_type` varchar(32) DEFAULT NULL COMMENT 'Data Type',
  PRIMARY KEY (`product_link_attribute_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_LINK_TYPE_ID` (`link_type_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute`
--

LOCK TABLES `catalog_product_link_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute` VALUES (1,1,'position','int'),(2,4,'position','int'),(3,5,'position','int'),(4,3,'position','int'),(5,3,'qty','decimal');
/*!40000 ALTER TABLE `catalog_product_link_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_decimal`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute_decimal` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int unsigned NOT NULL COMMENT 'Link ID',
  `value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_DEC_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_DECIMAL_LINK_ID` (`link_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_DEC_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_AB2EFA9A14F7BCF1D5400056203D14B6` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Decimal Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_decimal`
--

LOCK TABLES `catalog_product_link_attribute_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_int`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute_int` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int unsigned NOT NULL COMMENT 'Link ID',
  `value` int NOT NULL DEFAULT '0' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_INT_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_INT_LINK_ID` (`link_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_INT_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_D6D878F8BA2A4282F8DDED7E6E3DE35C` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Integer Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_int`
--

LOCK TABLES `catalog_product_link_attribute_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_varchar`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute_varchar` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Product Link Attribute ID',
  `link_id` int unsigned NOT NULL COMMENT 'Link ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_VCHR_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_VARCHAR_LINK_ID` (`link_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_VCHR_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_DEE9C4DA61CFCC01DFCF50F0D79CEA51` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Varchar Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_varchar`
--

LOCK TABLES `catalog_product_link_attribute_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_varchar` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link_attribute_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_type`
--

DROP TABLE IF EXISTS `catalog_product_link_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_type` (
  `link_type_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link Type ID',
  `code` varchar(32) DEFAULT NULL COMMENT 'Code',
  PRIMARY KEY (`link_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Type Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_type`
--

LOCK TABLES `catalog_product_link_type` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_type` DISABLE KEYS */;
INSERT INTO `catalog_product_link_type` VALUES (1,'relation'),(3,'super'),(4,'up_sell'),(5,'cross_sell');
/*!40000 ALTER TABLE `catalog_product_link_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option`
--

DROP TABLE IF EXISTS `catalog_product_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `type` varchar(50) DEFAULT NULL COMMENT 'Type',
  `is_require` smallint NOT NULL DEFAULT '1' COMMENT 'Is Required',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `max_characters` int unsigned DEFAULT NULL COMMENT 'Max Characters',
  `file_extension` varchar(50) DEFAULT NULL COMMENT 'File Extension',
  `image_size_x` smallint unsigned DEFAULT NULL COMMENT 'Image Size X',
  `image_size_y` smallint unsigned DEFAULT NULL COMMENT 'Image Size Y',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_OPT_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option`
--

LOCK TABLES `catalog_product_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_price`
--

DROP TABLE IF EXISTS `catalog_product_option_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_price` (
  `option_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Price ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_price_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_PRICE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRICE_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_OPT_PRICE_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_OPTION_PRICE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_price`
--

LOCK TABLES `catalog_product_option_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_title`
--

DROP TABLE IF EXISTS `catalog_product_option_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_title` (
  `option_title_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Title ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`option_title_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TITLE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_OPT_TTL_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_OPTION_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_title`
--

LOCK TABLES `catalog_product_option_title` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_title` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_title` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_price`
--

DROP TABLE IF EXISTS `catalog_product_option_type_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_type_price` (
  `option_type_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Price ID',
  `option_type_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_type_price_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_B523E3378E8602F376CC415825576B7F` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Type Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_price`
--

LOCK TABLES `catalog_product_option_type_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_type_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_title`
--

DROP TABLE IF EXISTS `catalog_product_option_type_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_type_title` (
  `option_type_title_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Title ID',
  `option_type_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`option_type_title_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C085B9CF2C2A302E8043FDEA1937D6A2` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Type Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_title`
--

LOCK TABLES `catalog_product_option_type_title` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_title` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_type_title` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_value`
--

DROP TABLE IF EXISTS `catalog_product_option_type_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_type_value` (
  `option_type_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_type_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_VALUE_OPTION_ID` (`option_id`),
  CONSTRAINT `CAT_PRD_OPT_TYPE_VAL_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Type Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_value`
--

LOCK TABLES `catalog_product_option_type_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_type_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_relation`
--

DROP TABLE IF EXISTS `catalog_product_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_relation` (
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int unsigned NOT NULL COMMENT 'Child ID',
  PRIMARY KEY (`parent_id`,`child_id`),
  KEY `CATALOG_PRODUCT_RELATION_CHILD_ID` (`child_id`),
  CONSTRAINT `CAT_PRD_RELATION_CHILD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`child_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_RELATION_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_relation`
--

LOCK TABLES `catalog_product_relation` WRITE;
/*!40000 ALTER TABLE `catalog_product_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_super_attribute` (
  `product_super_attribute_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Super Attribute ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `position` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`product_super_attribute_id`),
  UNIQUE KEY `CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRODUCT_ID_ATTRIBUTE_ID` (`product_id`,`attribute_id`),
  CONSTRAINT `CAT_PRD_SPR_ATTR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Super Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute`
--

LOCK TABLES `catalog_product_super_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute_label`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_super_attribute_label` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_super_attribute_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Super Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `use_default` smallint unsigned DEFAULT '0' COMMENT 'Use Default Value',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_SPR_ATTR_LBL_PRD_SPR_ATTR_ID_STORE_ID` (`product_super_attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_309442281DF7784210ED82B2CC51E5D5` FOREIGN KEY (`product_super_attribute_id`) REFERENCES `catalog_product_super_attribute` (`product_super_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Super Attribute Label Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute_label`
--

LOCK TABLES `catalog_product_super_attribute_label` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_link`
--

DROP TABLE IF EXISTS `catalog_product_super_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_super_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `CATALOG_PRODUCT_SUPER_LINK_PRODUCT_ID_PARENT_ID` (`product_id`,`parent_id`),
  KEY `CATALOG_PRODUCT_SUPER_LINK_PARENT_ID` (`parent_id`),
  CONSTRAINT `CAT_PRD_SPR_LNK_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_SPR_LNK_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Super Link Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_link`
--

LOCK TABLES `catalog_product_super_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_website`
--

DROP TABLE IF EXISTS `catalog_product_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_website` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_WS_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_WEBSITE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product To Website Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_website`
--

LOCK TABLES `catalog_product_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_website` DISABLE KEYS */;
INSERT INTO `catalog_product_website` VALUES (1,1),(2,1);
/*!40000 ALTER TABLE `catalog_product_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_url_rewrite_product_category`
--

DROP TABLE IF EXISTS `catalog_url_rewrite_product_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_url_rewrite_product_category` (
  `url_rewrite_id` int unsigned NOT NULL COMMENT 'url_rewrite_id',
  `category_id` int unsigned NOT NULL COMMENT 'category_id',
  `product_id` int unsigned NOT NULL COMMENT 'product_id',
  PRIMARY KEY (`url_rewrite_id`),
  KEY `CAT_URL_REWRITE_PRD_CTGR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` (`product_id`),
  KEY `CATALOG_URL_REWRITE_PRODUCT_CATEGORY_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  CONSTRAINT `CAT_URL_REWRITE_PRD_CTGR_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_URL_REWRITE_PRD_CTGR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_BB79E64705D7F17FE181F23144528FC8` FOREIGN KEY (`url_rewrite_id`) REFERENCES `url_rewrite` (`url_rewrite_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='url_rewrite_relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_url_rewrite_product_category`
--

LOCK TABLES `catalog_url_rewrite_product_category` WRITE;
/*!40000 ALTER TABLE `catalog_url_rewrite_product_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_url_rewrite_product_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock`
--

DROP TABLE IF EXISTS `cataloginventory_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock` (
  `stock_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Stock ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_name` varchar(255) DEFAULT NULL COMMENT 'Stock Name',
  PRIMARY KEY (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock`
--

LOCK TABLES `cataloginventory_stock` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock` VALUES (1,0,'Default');
/*!40000 ALTER TABLE `cataloginventory_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_item`
--

DROP TABLE IF EXISTS `cataloginventory_stock_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_item` (
  `item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Item ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `stock_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Stock ID',
  `qty` decimal(12,4) DEFAULT NULL COMMENT 'Qty',
  `min_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Min Qty',
  `use_config_min_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Qty',
  `is_qty_decimal` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Qty Decimal',
  `backorders` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Backorders',
  `use_config_backorders` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Backorders',
  `min_sale_qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'Min Sale Qty',
  `use_config_min_sale_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Sale Qty',
  `max_sale_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Max Sale Qty',
  `use_config_max_sale_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Max Sale Qty',
  `is_in_stock` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is In Stock',
  `low_stock_date` timestamp NULL DEFAULT NULL COMMENT 'Low Stock Date',
  `notify_stock_qty` decimal(12,4) DEFAULT NULL COMMENT 'Notify Stock Qty',
  `use_config_notify_stock_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Notify Stock Qty',
  `manage_stock` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Manage Stock',
  `use_config_manage_stock` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Manage Stock',
  `stock_status_changed_auto` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Stock Status Changed Automatically',
  `use_config_qty_increments` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Qty Increments',
  `qty_increments` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty Increments',
  `use_config_enable_qty_inc` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Enable Qty Increments',
  `enable_qty_increments` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Enable Qty Increments',
  `is_decimal_divided` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Divided into Multiple Boxes for Shipping',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `CATALOGINVENTORY_STOCK_ITEM_PRODUCT_ID_STOCK_ID` (`product_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_WEBSITE_ID` (`website_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_WEBSITE_ID_PRODUCT_ID` (`website_id`,`product_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_STOCK_ID` (`stock_id`),
  CONSTRAINT `CATINV_STOCK_ITEM_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATINV_STOCK_ITEM_STOCK_ID_CATINV_STOCK_STOCK_ID` FOREIGN KEY (`stock_id`) REFERENCES `cataloginventory_stock` (`stock_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_item`
--

LOCK TABLES `cataloginventory_stock_item` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_item` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_item` VALUES (1,1,1,11111.0000,0.0000,1,0,0,1,1.0000,1,10000.0000,1,1,NULL,1.0000,1,1,1,0,1,1.0000,1,0,0,0),(2,2,1,1000.0000,0.0000,1,0,0,1,1.0000,1,10000.0000,1,1,NULL,1.0000,1,1,1,0,1,1.0000,1,0,0,0);
/*!40000 ALTER TABLE `cataloginventory_stock_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_WEBSITE_ID` (`website_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_STATUS` (`stock_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status`
--

LOCK TABLES `cataloginventory_stock_status` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status` VALUES (1,0,1,11111.0000,1),(2,0,1,1000.0000,1);
/*!40000 ALTER TABLE `cataloginventory_stock_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_idx`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status_idx` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_IDX_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_IDX_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status Indexer Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status_idx`
--

LOCK TABLES `cataloginventory_stock_status_idx` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_replica`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status_replica` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_WEBSITE_ID` (`website_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_STATUS` (`stock_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status_replica`
--

LOCK TABLES `cataloginventory_stock_status_replica` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_replica` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status_replica` VALUES (1,0,1,11111.0000,1);
/*!40000 ALTER TABLE `cataloginventory_stock_status_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_tmp`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status_tmp` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_TMP_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_TMP_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status Indexer Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status_tmp`
--

LOCK TABLES `cataloginventory_stock_status_tmp` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `cataloginventory_stock_status_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule`
--

DROP TABLE IF EXISTS `catalogrule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `from_date` date DEFAULT NULL COMMENT 'From',
  `to_date` date DEFAULT NULL COMMENT 'To',
  `is_active` smallint NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `conditions_serialized` mediumtext COMMENT 'Conditions Serialized',
  `actions_serialized` mediumtext COMMENT 'Actions Serialized',
  `stop_rules_processing` smallint NOT NULL DEFAULT '1' COMMENT 'Stop Rules Processing',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action',
  `discount_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Discount Amount',
  PRIMARY KEY (`rule_id`),
  KEY `CATALOGRULE_IS_ACTIVE_SORT_ORDER_TO_DATE_FROM_DATE` (`is_active`,`sort_order`,`to_date`,`from_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule`
--

LOCK TABLES `catalogrule` WRITE;
/*!40000 ALTER TABLE `catalogrule` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_customer_group`
--

DROP TABLE IF EXISTS `catalogrule_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_customer_group` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  PRIMARY KEY (`rule_id`,`customer_group_id`),
  KEY `CATALOGRULE_CUSTOMER_GROUP_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `CATALOGRULE_CUSTOMER_GROUP_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `CATRULE_CSTR_GROUP_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Rules To Customer Groups Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_customer_group`
--

LOCK TABLES `catalogrule_customer_group` WRITE;
/*!40000 ALTER TABLE `catalogrule_customer_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_customer_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_group_website`
--

DROP TABLE IF EXISTS `catalogrule_group_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_group_website` (
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`rule_id`,`customer_group_id`,`website_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Group Website';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_group_website`
--

LOCK TABLES `catalogrule_group_website` WRITE;
/*!40000 ALTER TABLE `catalogrule_group_website` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_group_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_group_website_replica`
--

DROP TABLE IF EXISTS `catalogrule_group_website_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_group_website_replica` (
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`rule_id`,`customer_group_id`,`website_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Group Website';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_group_website_replica`
--

LOCK TABLES `catalogrule_group_website_replica` WRITE;
/*!40000 ALTER TABLE `catalogrule_group_website_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_group_website_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product`
--

DROP TABLE IF EXISTS `catalogrule_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product` (
  `rule_product_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product ID',
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `from_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'From Time',
  `to_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'To time',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `action_operator` varchar(10) DEFAULT 'to_fixed' COMMENT 'Action Operator',
  `action_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Action Amount',
  `action_stop` smallint NOT NULL DEFAULT '0' COMMENT 'Action Stop',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`rule_product_id`),
  UNIQUE KEY `UNQ_EAA51B56FF092A0DCB795D1CEF812B7B` (`rule_id`,`from_time`,`to_time`,`website_id`,`customer_group_id`,`product_id`,`sort_order`),
  KEY `CATALOGRULE_PRODUCT_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_FROM_TIME` (`from_time`),
  KEY `CATALOGRULE_PRODUCT_TO_TIME` (`to_time`),
  KEY `CATALOGRULE_PRODUCT_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product`
--

LOCK TABLES `catalogrule_product` WRITE;
/*!40000 ALTER TABLE `catalogrule_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product_price`
--

DROP TABLE IF EXISTS `catalogrule_product_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product_price` (
  `rule_product_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product PriceId',
  `rule_date` date NOT NULL COMMENT 'Rule Date',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `rule_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Rule Price',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `latest_start_date` date DEFAULT NULL COMMENT 'Latest StartDate',
  `earliest_end_date` date DEFAULT NULL COMMENT 'Earliest EndDate',
  PRIMARY KEY (`rule_product_price_id`),
  UNIQUE KEY `CATRULE_PRD_PRICE_RULE_DATE_WS_ID_CSTR_GROUP_ID_PRD_ID` (`rule_date`,`website_id`,`customer_group_id`,`product_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product_price`
--

LOCK TABLES `catalogrule_product_price` WRITE;
/*!40000 ALTER TABLE `catalogrule_product_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_product_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product_price_replica`
--

DROP TABLE IF EXISTS `catalogrule_product_price_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product_price_replica` (
  `rule_product_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product PriceId',
  `rule_date` date NOT NULL COMMENT 'Rule Date',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `rule_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Rule Price',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `latest_start_date` date DEFAULT NULL COMMENT 'Latest StartDate',
  `earliest_end_date` date DEFAULT NULL COMMENT 'Earliest EndDate',
  PRIMARY KEY (`rule_product_price_id`),
  UNIQUE KEY `CATRULE_PRD_PRICE_RULE_DATE_WS_ID_CSTR_GROUP_ID_PRD_ID` (`rule_date`,`website_id`,`customer_group_id`,`product_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product_price_replica`
--

LOCK TABLES `catalogrule_product_price_replica` WRITE;
/*!40000 ALTER TABLE `catalogrule_product_price_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_product_price_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product_replica`
--

DROP TABLE IF EXISTS `catalogrule_product_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product_replica` (
  `rule_product_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product ID',
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `from_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'From Time',
  `to_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'To time',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `action_operator` varchar(10) DEFAULT 'to_fixed' COMMENT 'Action Operator',
  `action_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Action Amount',
  `action_stop` smallint NOT NULL DEFAULT '0' COMMENT 'Action Stop',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`rule_product_id`),
  UNIQUE KEY `UNQ_EAA51B56FF092A0DCB795D1CEF812B7B` (`rule_id`,`from_time`,`to_time`,`website_id`,`customer_group_id`,`product_id`,`sort_order`),
  KEY `CATALOGRULE_PRODUCT_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_FROM_TIME` (`from_time`),
  KEY `CATALOGRULE_PRODUCT_TO_TIME` (`to_time`),
  KEY `CATALOGRULE_PRODUCT_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product_replica`
--

LOCK TABLES `catalogrule_product_replica` WRITE;
/*!40000 ALTER TABLE `catalogrule_product_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_product_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_website`
--

DROP TABLE IF EXISTS `catalogrule_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_website` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`rule_id`,`website_id`),
  KEY `CATALOGRULE_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CATALOGRULE_WEBSITE_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOGRULE_WEBSITE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Rules To Websites Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_website`
--

LOCK TABLES `catalogrule_website` WRITE;
/*!40000 ALTER TABLE `catalogrule_website` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_recommendations`
--

DROP TABLE IF EXISTS `catalogsearch_recommendations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogsearch_recommendations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `query_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Query ID',
  `relation_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Relation ID',
  PRIMARY KEY (`id`),
  KEY `CATALOGSEARCH_RECOMMENDATIONS_QUERY_ID_SEARCH_QUERY_QUERY_ID` (`query_id`),
  KEY `CATALOGSEARCH_RECOMMENDATIONS_RELATION_ID_SEARCH_QUERY_QUERY_ID` (`relation_id`),
  CONSTRAINT `CATALOGSEARCH_RECOMMENDATIONS_QUERY_ID_SEARCH_QUERY_QUERY_ID` FOREIGN KEY (`query_id`) REFERENCES `search_query` (`query_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOGSEARCH_RECOMMENDATIONS_RELATION_ID_SEARCH_QUERY_QUERY_ID` FOREIGN KEY (`relation_id`) REFERENCES `search_query` (`query_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Advanced Search Recommendations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogsearch_recommendations`
--

LOCK TABLES `catalogsearch_recommendations` WRITE;
/*!40000 ALTER TABLE `catalogsearch_recommendations` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogsearch_recommendations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checkout_agreement`
--

DROP TABLE IF EXISTS `checkout_agreement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_agreement` (
  `agreement_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Agreement ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `content` text COMMENT 'Content',
  `content_height` varchar(25) DEFAULT NULL COMMENT 'Content Height',
  `checkbox_text` text COMMENT 'Checkbox Text',
  `is_active` smallint NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `is_html` smallint NOT NULL DEFAULT '0' COMMENT 'Is Html',
  `mode` smallint NOT NULL DEFAULT '0' COMMENT 'Applied mode',
  PRIMARY KEY (`agreement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Checkout Agreement';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checkout_agreement`
--

LOCK TABLES `checkout_agreement` WRITE;
/*!40000 ALTER TABLE `checkout_agreement` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_agreement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checkout_agreement_store`
--

DROP TABLE IF EXISTS `checkout_agreement_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_agreement_store` (
  `agreement_id` int unsigned NOT NULL COMMENT 'Agreement ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`agreement_id`,`store_id`),
  KEY `CHECKOUT_AGREEMENT_STORE_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CHECKOUT_AGREEMENT_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CHKT_AGRT_STORE_AGRT_ID_CHKT_AGRT_AGRT_ID` FOREIGN KEY (`agreement_id`) REFERENCES `checkout_agreement` (`agreement_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Checkout Agreement Store';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checkout_agreement_store`
--

LOCK TABLES `checkout_agreement_store` WRITE;
/*!40000 ALTER TABLE `checkout_agreement_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_agreement_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_block`
--

DROP TABLE IF EXISTS `cms_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_block` (
  `block_id` smallint NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `title` varchar(255) NOT NULL COMMENT 'Block Title',
  `identifier` varchar(255) NOT NULL COMMENT 'Block String Identifier',
  `content` mediumtext COMMENT 'Block Content',
  `creation_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Block Creation Time',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Block Modification Time',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'Is Block Active',
  PRIMARY KEY (`block_id`),
  KEY `CMS_BLOCK_IDENTIFIER` (`identifier`),
  FULLTEXT KEY `CMS_BLOCK_TITLE_IDENTIFIER_CONTENT` (`title`,`identifier`,`content`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CMS Block Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_block`
--

LOCK TABLES `cms_block` WRITE;
/*!40000 ALTER TABLE `cms_block` DISABLE KEYS */;
/*!40000 ALTER TABLE `cms_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_block_store`
--

DROP TABLE IF EXISTS `cms_block_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_block_store` (
  `block_id` smallint NOT NULL,
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`block_id`,`store_id`),
  KEY `CMS_BLOCK_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CMS_BLOCK_STORE_BLOCK_ID_CMS_BLOCK_BLOCK_ID` FOREIGN KEY (`block_id`) REFERENCES `cms_block` (`block_id`) ON DELETE CASCADE,
  CONSTRAINT `CMS_BLOCK_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CMS Block To Store Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_block_store`
--

LOCK TABLES `cms_block_store` WRITE;
/*!40000 ALTER TABLE `cms_block_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `cms_block_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_page`
--

DROP TABLE IF EXISTS `cms_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_page` (
  `page_id` smallint NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Page Title',
  `page_layout` varchar(255) DEFAULT NULL COMMENT 'Page Layout',
  `meta_keywords` text COMMENT 'Page Meta Keywords',
  `meta_description` text COMMENT 'Page Meta Description',
  `identifier` varchar(100) DEFAULT NULL COMMENT 'Page String Identifier',
  `content_heading` varchar(255) DEFAULT NULL COMMENT 'Page Content Heading',
  `content` mediumtext COMMENT 'Page Content',
  `creation_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Page Creation Time',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Page Modification Time',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'Is Page Active',
  `sort_order` smallint NOT NULL DEFAULT '0' COMMENT 'Page Sort Order',
  `layout_update_xml` text COMMENT 'Page Layout Update Content',
  `custom_theme` varchar(100) DEFAULT NULL COMMENT 'Page Custom Theme',
  `custom_root_template` varchar(255) DEFAULT NULL COMMENT 'Page Custom Template',
  `custom_layout_update_xml` text COMMENT 'Page Custom Layout Update Content',
  `layout_update_selected` varchar(128) DEFAULT NULL COMMENT 'Page Custom Layout File',
  `custom_theme_from` date DEFAULT NULL COMMENT 'Page Custom Theme Active From Date',
  `custom_theme_to` date DEFAULT NULL COMMENT 'Page Custom Theme Active To Date',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'Page Meta Title',
  PRIMARY KEY (`page_id`),
  KEY `CMS_PAGE_IDENTIFIER` (`identifier`),
  FULLTEXT KEY `CMS_PAGE_TITLE_META_KEYWORDS_META_DESCRIPTION_IDENTIFIER_CONTENT` (`title`,`meta_keywords`,`meta_description`,`identifier`,`content`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='CMS Page Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_page`
--

LOCK TABLES `cms_page` WRITE;
/*!40000 ALTER TABLE `cms_page` DISABLE KEYS */;
INSERT INTO `cms_page` VALUES (1,'404 Not Found','2columns-right','Page keywords','Page description','no-route','Whoops, our bad...','<dl>\r\n<dt>The page you requested was not found, and we have a fine guess why.</dt>\r\n<dd>\r\n<ul class=\"disc\">\r\n<li>If you typed the URL directly, please make sure the spelling is correct.</li>\r\n<li>If you clicked on a link to get here, the link is outdated.</li>\r\n</ul></dd>\r\n</dl>\r\n<dl>\r\n<dt>What can you do?</dt>\r\n<dd>Have no fear, help is near! There are many ways you can get back on track with Magento Store.</dd>\r\n<dd>\r\n<ul class=\"disc\">\r\n<li><a href=\"#\" onclick=\"history.go(-1); return false;\">Go back</a> to the previous page.</li>\r\n<li>Use the search bar at the top of the page to search for your products.</li>\r\n<li>Follow these links to get you back on track!<br /><a href=\"{{store url=\"\"}}\">Store Home</a> <span class=\"separator\">|</span> <a href=\"{{store url=\"customer/account\"}}\">My Account</a></li></ul></dd></dl>\r\n','2024-05-03 06:06:28','2024-05-03 06:06:28',1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'Home page','1column',NULL,NULL,'home','Home Page','<p>CMS homepage content goes here.</p>\r\n','2024-05-03 06:06:28','2024-05-03 06:06:31',1,0,'<!--\n    <referenceContainer name=\"right\">\n        <referenceBlock name=\"catalog.compare.sidebar\" remove=\"true\" />\n    </referenceContainer>-->',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Enable Cookies','1column',NULL,NULL,'enable-cookies','What are Cookies?','<div class=\"enable-cookies cms-content\">\r\n<p>\"Cookies\" are little pieces of data we send when you visit our store. Cookies help us get to know you better and personalize your experience. Plus they help protect you and other shoppers from fraud.</p>\r\n<p style=\"margin-bottom: 20px;\">Set your browser to accept cookies so you can buy items, save items, and receive customized recommendations. Here’s how:</p>\r\n<ul>\r\n<li><a href=\"https://support.google.com/accounts/answer/61416?hl=en\" target=\"_blank\">Google Chrome</a></li>\r\n<li><a href=\"http://windows.microsoft.com/en-us/internet-explorer/delete-manage-cookies\" target=\"_blank\">Internet Explorer</a></li>\r\n<li><a href=\"http://support.apple.com/kb/PH19214\" target=\"_blank\">Safari</a></li>\r\n<li><a href=\"https://support.mozilla.org/en-US/kb/enable-and-disable-cookies-website-preferences\" target=\"_blank\">Mozilla/Firefox</a></li>\r\n</ul>\r\n</div>','2024-05-03 06:06:28','2024-05-03 06:06:28',1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Privacy and Cookie Policy','1column',NULL,NULL,'privacy-policy-cookie-restriction-mode','Privacy and Cookie Policy','<div class=\"privacy-policy cms-content\">\n    <div class=\"message info\">\n        <span>\n            Please replace this text with you Privacy Policy.\n            Please add any additional cookies your website uses below (e.g. Google Analytics).\n        </span>\n    </div>\n    <p>\n        This privacy policy sets out how this website (hereafter \"the Store\") uses and protects any information that\n        you give the Store while using this website. The Store is committed to ensuring that your privacy is protected.\n        Should we ask you to provide certain information by which you can be identified when using this website, then\n        you can be assured that it will only be used in accordance with this privacy statement. The Store may change\n        this policy from time to time by updating this page. You should check this page from time to time to ensure\n        that you are happy with any changes.\n    </p>\n    <h2>What we collect</h2>\n    <p>We may collect the following information:</p>\n    <ul>\n        <li>name</li>\n        <li>contact information including email address</li>\n        <li>demographic information such as postcode, preferences and interests</li>\n        <li>other information relevant to customer surveys and/or offers</li>\n    </ul>\n    <p>\n        For the exhaustive list of cookies we collect see the <a href=\"#list\">List of cookies we collect</a> section.\n    </p>\n    <h2>What we do with the information we gather</h2>\n    <p>\n        We require this information to understand your needs and provide you with a better service,\n        and in particular for the following reasons:\n    </p>\n    <ul>\n        <li>Internal record keeping.</li>\n        <li>We may use the information to improve our products and services.</li>\n        <li>\n            We may periodically send promotional emails about new products, special offers or other information which we\n            think you may find interesting using the email address which you have provided.\n        </li>\n        <li>\n            From time to time, we may also use your information to contact you for market research purposes.\n            We may contact you by email, phone, fax or mail. We may use the information to customise the website\n            according to your interests.\n        </li>\n    </ul>\n    <h2>Security</h2>\n    <p>\n        We are committed to ensuring that your information is secure. In order to prevent unauthorised access or\n        disclosure, we have put in place suitable physical, electronic and managerial procedures to safeguard and\n        secure the information we collect online.\n    </p>\n    <h2>How we use cookies</h2>\n    <p>\n        A cookie is a small file which asks permission to be placed on your computer\'s hard drive.\n        Once you agree, the file is added and the cookie helps analyse web traffic or lets you know when you visit\n        a particular site. Cookies allow web applications to respond to you as an individual. The web application\n        can tailor its operations to your needs, likes and dislikes by gathering and remembering information about\n        your preferences.\n    </p>\n    <p>\n        We use traffic log cookies to identify which pages are being used. This helps us analyse data about web page\n        traffic and improve our website in order to tailor it to customer needs. We only use this information for\n        statistical analysis purposes and then the data is removed from the system.\n    </p>\n    <p>\n        Overall, cookies help us provide you with a better website, by enabling us to monitor which pages you find\n        useful and which you do not. A cookie in no way gives us access to your computer or any information about you,\n        other than the data you choose to share with us. You can choose to accept or decline cookies.\n        Most web browsers automatically accept cookies, but you can usually modify your browser setting\n        to decline cookies if you prefer. This may prevent you from taking full advantage of the website.\n    </p>\n    <h2>Links to other websites</h2>\n    <p>\n        Our website may contain links to other websites of interest. However, once you have used these links\n        to leave our site, you should note that we do not have any control over that other website.\n        Therefore, we cannot be responsible for the protection and privacy of any information which you provide whilst\n        visiting such sites and such sites are not governed by this privacy statement.\n        You should exercise caution and look at the privacy statement applicable to the website in question.\n    </p>\n    <h2>Controlling your personal information</h2>\n    <p>You may choose to restrict the collection or use of your personal information in the following ways:</p>\n    <ul>\n        <li>\n            whenever you are asked to fill in a form on the website, look for the box that you can click to indicate\n            that you do not want the information to be used by anybody for direct marketing purposes\n        </li>\n        <li>\n            if you have previously agreed to us using your personal information for direct marketing purposes,\n            you may change your mind at any time by letting us know using our Contact Us information\n        </li>\n    </ul>\n    <p>\n        We will not sell, distribute or lease your personal information to third parties unless we have your permission\n        or are required by law to do so. We may use your personal information to send you promotional information\n        about third parties which we think you may find interesting if you tell us that you wish this to happen.\n    </p>\n    <p>\n        You may request details of personal information which we hold about you under the Data Protection Act 1998.\n        A small fee will be payable. If you would like a copy of the information held on you please email us this\n        request using our Contact Us information.\n    </p>\n    <p>\n        If you believe that any information we are holding on you is incorrect or incomplete,\n        please write to or email us as soon as possible, at the above address.\n        We will promptly correct any information found to be incorrect.\n    </p>\n    <h2><a name=\"list\"></a>List of cookies we collect</h2>\n    <p>The table below lists the cookies we collect and what information they store.</p>\n    <table class=\"data-table data-table-definition-list\">\n        <thead>\n        <tr>\n            <th>Cookie Name</th>\n            <th>Cookie Description</th>\n        </tr>\n        </thead>\n        <tbody>\n            <tr>\n                <th>FORM_KEY</th>\n                <td>Stores randomly generated key used to prevent forged requests.</td>\n            </tr>\n            <tr>\n                <th>PHPSESSID</th>\n                <td>Your session ID on the server.</td>\n            </tr>\n            <tr>\n                <th>GUEST-VIEW</th>\n                <td>Allows guests to view and edit their orders.</td>\n            </tr>\n            <tr>\n                <th>PERSISTENT_SHOPPING_CART</th>\n                <td>A link to information about your cart and viewing history, if you have asked for this.</td>\n            </tr>\n            <tr>\n                <th>STF</th>\n                <td>Information on products you have emailed to friends.</td>\n            </tr>\n            <tr>\n                <th>STORE</th>\n                <td>The store view or language you have selected.</td>\n            </tr>\n            <tr>\n                <th>USER_ALLOWED_SAVE_COOKIE</th>\n                <td>Indicates whether a customer allowed to use cookies.</td>\n            </tr>\n            <tr>\n                <th>MAGE-CACHE-SESSID</th>\n                <td>Facilitates caching of content on the browser to make pages load faster.</td>\n            </tr>\n            <tr>\n                <th>MAGE-CACHE-STORAGE</th>\n                <td>Facilitates caching of content on the browser to make pages load faster.</td>\n            </tr>\n            <tr>\n                <th>MAGE-CACHE-STORAGE-SECTION-INVALIDATION</th>\n                <td>Facilitates caching of content on the browser to make pages load faster.</td>\n            </tr>\n            <tr>\n                <th>MAGE-CACHE-TIMEOUT</th>\n                <td>Facilitates caching of content on the browser to make pages load faster.</td>\n            </tr>\n            <tr>\n                <th>SECTION-DATA-IDS</th>\n                <td>Facilitates caching of content on the browser to make pages load faster.</td>\n            </tr>\n            <tr>\n                <th>PRIVATE_CONTENT_VERSION</th>\n                <td>Facilitates caching of content on the browser to make pages load faster.</td>\n            </tr>\n            <tr>\n                <th>X-MAGENTO-VARY</th>\n                <td>Facilitates caching of content on the server to make pages load faster.</td>\n            </tr>\n            <tr>\n                <th>MAGE-TRANSLATION-FILE-VERSION</th>\n                <td>Facilitates translation of content to other languages.</td>\n            </tr>\n            <tr>\n                <th>MAGE-TRANSLATION-STORAGE</th>\n                <td>Facilitates translation of content to other languages.</td>\n            </tr>\n        </tbody>\n    </table>\n</div>','2024-05-03 06:06:28','2024-05-03 06:06:28',1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cms_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_page_store`
--

DROP TABLE IF EXISTS `cms_page_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_page_store` (
  `page_id` smallint NOT NULL COMMENT 'Entity ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`page_id`,`store_id`),
  KEY `CMS_PAGE_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CMS_PAGE_STORE_PAGE_ID_CMS_PAGE_PAGE_ID` FOREIGN KEY (`page_id`) REFERENCES `cms_page` (`page_id`) ON DELETE CASCADE,
  CONSTRAINT `CMS_PAGE_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CMS Page To Store Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_page_store`
--

LOCK TABLES `cms_page_store` WRITE;
/*!40000 ALTER TABLE `cms_page_store` DISABLE KEYS */;
INSERT INTO `cms_page_store` VALUES (1,0),(2,0),(3,0),(4,0);
/*!40000 ALTER TABLE `cms_page_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_config_data`
--

DROP TABLE IF EXISTS `core_config_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `core_config_data` (
  `config_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Config ID',
  `scope` varchar(8) NOT NULL DEFAULT 'default' COMMENT 'Config Scope',
  `scope_id` int NOT NULL DEFAULT '0' COMMENT 'Config Scope ID',
  `path` varchar(255) NOT NULL DEFAULT 'general' COMMENT 'Config Path',
  `value` text COMMENT 'Config Value',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `CORE_CONFIG_DATA_SCOPE_SCOPE_ID_PATH` (`scope`,`scope_id`,`path`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb3 COMMENT='Config Data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_config_data`
--

LOCK TABLES `core_config_data` WRITE;
/*!40000 ALTER TABLE `core_config_data` DISABLE KEYS */;
INSERT INTO `core_config_data` VALUES (1,'default',0,'web/seo/use_rewrites','1','2024-05-03 06:06:21'),(2,'default',0,'web/unsecure/base_url','https://aidatshawdev.katdev.com/','2024-05-03 10:31:00'),(3,'default',0,'general/locale/code','en_US','2024-05-03 06:06:21'),(4,'default',0,'general/locale/timezone','America/Chicago','2024-05-03 06:06:21'),(5,'default',0,'currency/options/base','EUR','2024-06-03 09:25:33'),(6,'default',0,'currency/options/default','EUR','2024-06-03 09:25:33'),(7,'default',0,'currency/options/allow','EUR','2024-06-03 09:25:33'),(8,'default',0,'general/region/display_all','1','2024-05-03 06:06:22'),(9,'default',0,'general/region/state_required','AL,AR,AU,BG,BO,BR,BY,CA,CH,CL,CN,CO,CZ,DK,EC,EE,ES,GR,GY,HR,IN,IS,IT,LT,LV,MX,PE,PL,PT,PY,RO,SE,SR,US,UY,VE','2024-05-03 06:06:26'),(10,'default',0,'catalog/category/root_id','2','2024-05-03 06:06:29'),(11,'default',0,'analytics/subscription/enabled','1','2024-05-03 06:06:30'),(13,'default',0,'crontab/default/jobs/analytics_collect_data/schedule/cron_expr','00 02 * * *','2024-05-03 06:06:31'),(14,'default',0,'msp_securitysuite_recaptcha/frontend/enabled','0','2024-05-03 06:06:31'),(15,'default',0,'msp_securitysuite_recaptcha/backend/enabled','0','2024-05-03 06:06:31'),(16,'default',0,'twofactorauth/duo/application_key','m9MNw2g3sZQUyTfbCLpZug5SL2hw7QtLcOr95F7Dzy3j3QmnmpdkVScRce6DgLTU','2024-05-03 06:06:31'),(17,'default',0,'admin/usage/enabled','1','2024-05-03 13:08:32'),(18,'default',0,'system/full_page_cache/varnish/access_list','localhost','2024-05-03 13:27:50'),(19,'default',0,'system/full_page_cache/varnish/backend_host','localhost','2024-05-03 13:27:51'),(20,'default',0,'system/full_page_cache/varnish/backend_port','8080','2024-05-03 13:27:51'),(21,'default',0,'system/full_page_cache/varnish/grace_period','300','2024-05-03 13:27:51'),(22,'default',0,'system/mysqlmq/successful_messages_lifetime','10080','2024-05-03 13:28:11'),(23,'default',0,'system/mysqlmq/retry_inprogress_after','1440','2024-05-03 13:28:11'),(24,'default',0,'system/mysqlmq/failed_messages_lifetime','10080','2024-05-03 13:28:11'),(25,'default',0,'system/mysqlmq/new_messages_lifetime','10080','2024-05-03 13:28:11'),(26,'default',0,'system/security/max_session_size_admin','900000000000000','2024-05-03 13:28:11'),(27,'default',0,'system/backup/functionality_enabled','0','2024-05-03 13:28:11'),(28,'default',0,'system/bulk/lifetime','60','2024-05-03 13:28:11'),(29,'default',0,'system/media_storage_configuration/media_storage','0','2024-05-03 13:28:11'),(30,'default',0,'system/media_gallery/enabled','1','2024-05-03 13:28:11'),(31,'default',0,'system/media_gallery_renditions/enabled','1','2024-05-03 13:28:11'),(32,'default',0,'system/media_gallery_renditions/width','1000','2024-05-03 13:28:11'),(33,'default',0,'system/media_gallery_renditions/height','1000','2024-05-03 13:28:11'),(34,'default',0,'adobe_stock/integration/enabled','1','2024-05-03 13:28:11'),(35,'default',0,'adobe_ims/integration/admin_enabled','0','2024-05-03 13:28:11'),(36,'default',0,'adobe_ims/integration/api_key',NULL,'2024-05-03 13:28:11'),(37,'default',0,'adobe_ims/integration/private_key',NULL,'2024-05-03 13:28:11'),(38,'default',0,'admin/security/session_lifetime','9000000','2024-05-07 13:06:39'),(39,'websites',1,'design/head/shortcut_icon','websites/1/231215c.png','2024-05-31 16:58:00'),(40,'websites',1,'design/head/default_title','Club Albany - Bespoke Men Suits','2024-05-31 16:58:00'),(42,'default',0,'design/theme/theme_id','3','2024-05-31 16:59:01'),(43,'default',0,'design/pagination/pagination_frame','5','2024-05-31 16:59:01'),(44,'default',0,'design/pagination/pagination_frame_skip',NULL,'2024-05-31 16:59:01'),(45,'default',0,'design/pagination/anchor_text_for_previous',NULL,'2024-05-31 16:59:01'),(46,'default',0,'design/pagination/anchor_text_for_next',NULL,'2024-05-31 16:59:01'),(47,'default',0,'design/head/default_title','Magento Commerce','2024-05-31 16:59:01'),(48,'default',0,'design/head/title_prefix',NULL,'2024-05-31 16:59:01'),(49,'default',0,'design/head/title_suffix',NULL,'2024-05-31 16:59:01'),(50,'default',0,'design/head/default_description',NULL,'2024-05-31 16:59:01'),(51,'default',0,'design/head/default_keywords',NULL,'2024-05-31 16:59:01'),(52,'default',0,'design/head/includes',NULL,'2024-05-31 16:59:01'),(53,'default',0,'design/head/demonotice','0','2024-05-31 16:59:01'),(54,'default',0,'design/header/logo_width',NULL,'2024-05-31 16:59:01'),(55,'default',0,'design/header/logo_height',NULL,'2024-05-31 16:59:01'),(56,'default',0,'design/header/logo_alt',NULL,'2024-05-31 16:59:01'),(57,'default',0,'design/header/welcome','club albany welcome message','2024-05-31 16:59:01'),(58,'default',0,'design/header/translate_title','1','2024-05-31 16:59:01'),(59,'default',0,'design/footer/copyright','Copyright © 2013-present Magento, Inc. All rights reserved.','2024-05-31 16:59:01'),(60,'default',0,'design/footer/absolute_footer',NULL,'2024-05-31 16:59:01'),(61,'default',0,'design/footer/report_bugs','1','2024-05-31 16:59:01'),(62,'default',0,'design/search_engine_robots/default_robots','INDEX,FOLLOW','2024-05-31 16:59:01'),(63,'default',0,'design/search_engine_robots/custom_instructions',NULL,'2024-05-31 16:59:01'),(64,'default',0,'design/watermark/image_size',NULL,'2024-05-31 16:59:01'),(65,'default',0,'design/watermark/image_imageOpacity',NULL,'2024-05-31 16:59:01'),(66,'default',0,'design/watermark/image_position','stretch','2024-05-31 16:59:01'),(67,'default',0,'design/watermark/small_image_size',NULL,'2024-05-31 16:59:01'),(68,'default',0,'design/watermark/small_image_imageOpacity',NULL,'2024-05-31 16:59:01'),(69,'default',0,'design/watermark/small_image_position','stretch','2024-05-31 16:59:01'),(70,'default',0,'design/watermark/thumbnail_size',NULL,'2024-05-31 16:59:01'),(71,'default',0,'design/watermark/thumbnail_imageOpacity',NULL,'2024-05-31 16:59:01'),(72,'default',0,'design/watermark/thumbnail_position','stretch','2024-05-31 16:59:01'),(73,'default',0,'design/email/logo_alt',NULL,'2024-05-31 16:59:01'),(74,'default',0,'design/email/logo_width',NULL,'2024-05-31 16:59:01'),(75,'default',0,'design/email/logo_height',NULL,'2024-05-31 16:59:01'),(76,'default',0,'design/email/header_template','design_email_header_template','2024-05-31 16:59:01'),(77,'default',0,'design/email/footer_template','design_email_footer_template','2024-05-31 16:59:01'),(78,'stores',1,'design/header/logo_src','stores/1/231215c.png','2024-05-31 17:00:01'),(79,'default',0,'design/header/logo_src','default/231215c.png','2024-05-31 17:00:30'),(80,'stores',1,'design/head/shortcut_icon','stores/1/231215c.png','2024-05-31 17:03:50'),(82,'websites',1,'design/header/logo_src','websites/1/231215c.png','2024-05-31 17:05:22'),(83,'default',0,'design/head/shortcut_icon','default/231215c.png','2024-05-31 17:18:19'),(84,'default',0,'currency/fixerio/api_key',NULL,'2024-06-03 09:25:33'),(85,'default',0,'currency/fixerio/timeout','100','2024-06-03 09:25:33'),(86,'default',0,'currency/fixerio_apilayer/api_key',NULL,'2024-06-03 09:25:33'),(87,'default',0,'currency/fixerio_apilayer/timeout','100','2024-06-03 09:25:33'),(88,'default',0,'currency/currencyconverterapi/api_key',NULL,'2024-06-03 09:25:33'),(89,'default',0,'currency/currencyconverterapi/timeout','100','2024-06-03 09:25:33');
/*!40000 ALTER TABLE `core_config_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cron_schedule`
--

DROP TABLE IF EXISTS `cron_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cron_schedule` (
  `schedule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Schedule ID',
  `job_code` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Job Code',
  `status` varchar(7) NOT NULL DEFAULT 'pending' COMMENT 'Status',
  `messages` text COMMENT 'Messages',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `scheduled_at` timestamp NULL DEFAULT NULL COMMENT 'Scheduled At',
  `executed_at` timestamp NULL DEFAULT NULL COMMENT 'Executed At',
  `finished_at` timestamp NULL DEFAULT NULL COMMENT 'Finished At',
  PRIMARY KEY (`schedule_id`),
  KEY `CRON_SCHEDULE_JOB_CODE_STATUS_SCHEDULED_AT` (`job_code`,`status`,`scheduled_at`)
) ENGINE=InnoDB AUTO_INCREMENT=202925 DEFAULT CHARSET=utf8mb3 COMMENT='Cron Schedule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cron_schedule`
--

LOCK TABLES `cron_schedule` WRITE;
/*!40000 ALTER TABLE `cron_schedule` DISABLE KEYS */;
INSERT INTO `cron_schedule` VALUES (120401,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:22:00','2024-07-05 21:22:02',NULL),(120402,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:23:00','2024-07-05 21:23:02',NULL),(120403,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:24:00','2024-07-05 21:24:02',NULL),(120404,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:25:00','2024-07-05 21:25:02',NULL),(120405,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:26:00','2024-07-05 21:26:02',NULL),(120406,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:27:00','2024-07-05 21:27:02',NULL),(120407,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:28:00','2024-07-05 21:28:02',NULL),(120408,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:29:00','2024-07-05 21:29:02',NULL),(120409,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:30:00','2024-07-05 21:30:02',NULL),(120410,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:31:00','2024-07-05 21:31:02',NULL),(120411,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:32:00','2024-07-05 21:32:02',NULL),(120412,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:33:00','2024-07-05 21:33:02',NULL),(120413,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:34:00','2024-07-05 21:34:02',NULL),(120414,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:16:03','2024-07-05 21:35:00','2024-07-05 21:35:02',NULL),(120673,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:36:00','2024-07-05 21:36:02',NULL),(120674,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:37:00','2024-07-05 21:37:01',NULL),(120675,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:38:00','2024-07-05 21:38:02',NULL),(120676,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:39:00','2024-07-05 21:39:02',NULL),(120677,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:40:00','2024-07-05 21:40:02',NULL),(120678,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:41:00','2024-07-05 21:41:02',NULL),(120679,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:42:00','2024-07-05 21:42:02',NULL),(120680,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:43:00','2024-07-05 21:43:02',NULL),(120681,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:44:00','2024-07-05 21:44:02',NULL),(120682,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:45:00','2024-07-05 21:45:02',NULL),(120683,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:46:00','2024-07-05 21:46:01',NULL),(120684,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:47:00','2024-07-05 21:47:02',NULL),(120685,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:48:00','2024-07-05 21:48:02',NULL),(120686,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:49:00','2024-07-05 21:49:02',NULL),(120687,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:31:02','2024-07-05 21:50:00','2024-07-05 21:50:02',NULL),(120780,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120781,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120782,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120783,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120784,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120785,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120798,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120799,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120800,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120801,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120802,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120803,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120814,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120815,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120816,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120817,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120818,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120819,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120830,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120831,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120832,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120833,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120834,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120835,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120846,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120847,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120848,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120849,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120850,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120851,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120862,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120863,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120864,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120865,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120866,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120867,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120878,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120879,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120880,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120881,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120882,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120883,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120894,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120895,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120896,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120897,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120898,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120899,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120910,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 22:01:00','2024-07-05 21:47:02','2024-07-05 22:01:00',NULL,NULL),(120911,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120912,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 22:03:00','2024-07-05 21:47:02','2024-07-05 22:03:00',NULL,NULL),(120913,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120914,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120915,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120940,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-05 22:02:00','2024-07-05 21:47:02','2024-07-05 22:02:00',NULL,NULL),(120941,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-05 22:04:00','2024-07-05 21:47:02','2024-07-05 22:04:00',NULL,NULL),(120942,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-05 22:06:00','2024-07-05 21:47:02','2024-07-05 22:06:00',NULL,NULL),(120945,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-05 22:05:00','2024-07-05 21:47:02','2024-07-05 22:05:00',NULL,NULL),(120963,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-05 21:47:02','2024-07-05 22:01:00','2024-07-05 22:01:14',NULL),(120964,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:51:00','2024-07-05 21:51:02',NULL),(120965,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:52:00','2024-07-05 21:52:02',NULL),(120966,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:53:00','2024-07-05 21:53:02',NULL),(120967,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:54:00','2024-07-05 21:54:02',NULL),(120968,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:55:00','2024-07-05 21:55:02',NULL),(120969,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:56:00','2024-07-05 21:56:02',NULL),(120970,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:57:00','2024-07-05 21:57:02',NULL),(120971,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:58:00','2024-07-05 21:58:02',NULL),(120972,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 21:59:00','2024-07-05 21:59:02',NULL),(120973,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 22:00:00','2024-07-05 22:00:02',NULL),(120974,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 22:01:00','2024-07-05 22:01:02',NULL),(120975,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 22:02:00','2024-07-05 22:02:03',NULL),(120976,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 22:03:00','2024-07-05 22:03:02',NULL),(120977,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 22:04:00','2024-07-05 22:04:02',NULL),(120978,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 22:05:00','2024-07-05 22:05:02',NULL),(120979,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 21:47:02','2024-07-05 22:06:00','2024-07-05 22:06:02',NULL),(121289,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:07:00','2024-07-05 22:07:02',NULL),(121290,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:08:00','2024-07-05 22:08:02',NULL),(121291,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:09:00','2024-07-05 22:09:01',NULL),(121292,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:10:00','2024-07-05 22:10:02',NULL),(121293,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:11:00','2024-07-05 22:11:02',NULL),(121294,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:12:00','2024-07-05 22:12:02',NULL),(121295,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:13:00','2024-07-05 22:13:02',NULL),(121296,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:14:00','2024-07-05 22:14:02',NULL),(121297,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:15:00','2024-07-05 22:15:02',NULL),(121298,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:16:00','2024-07-05 22:16:02',NULL),(121299,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:17:00','2024-07-05 22:17:02',NULL),(121300,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:18:00','2024-07-05 22:18:02',NULL),(121301,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:19:00','2024-07-05 22:19:02',NULL),(121302,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:20:00','2024-07-05 22:20:02',NULL),(121303,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:02:03','2024-07-05 22:21:00','2024-07-05 22:21:02',NULL),(121576,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:22:00','2024-07-05 22:22:02',NULL),(121577,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:23:00','2024-07-05 22:23:02',NULL),(121578,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:24:00','2024-07-05 22:24:02',NULL),(121579,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:25:00','2024-07-05 22:25:02',NULL),(121580,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:26:00','2024-07-05 22:26:02',NULL),(121581,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:27:00','2024-07-05 22:27:02',NULL),(121582,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:28:00','2024-07-05 22:28:02',NULL),(121583,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:29:00','2024-07-05 22:29:02',NULL),(121584,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:30:00','2024-07-05 22:30:02',NULL),(121585,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:31:00','2024-07-05 22:31:02',NULL),(121586,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:32:00','2024-07-05 22:32:02',NULL),(121587,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:33:00','2024-07-05 22:33:03',NULL),(121588,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:34:00','2024-07-05 22:34:02',NULL),(121589,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:35:00','2024-07-05 22:35:02',NULL),(121590,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:36:00','2024-07-05 22:36:02',NULL),(121591,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:18:02','2024-07-05 22:37:00','2024-07-05 22:37:02',NULL),(121850,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:38:00','2024-07-05 22:38:02',NULL),(121851,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:39:00','2024-07-05 22:39:02',NULL),(121852,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:40:00','2024-07-05 22:40:02',NULL),(121853,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:41:00','2024-07-05 22:41:02',NULL),(121854,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:42:00','2024-07-05 22:42:02',NULL),(121855,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:43:00','2024-07-05 22:43:02',NULL),(121856,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:44:00','2024-07-05 22:44:02',NULL),(121857,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:45:00','2024-07-05 22:45:02',NULL),(121858,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:46:00','2024-07-05 22:46:02',NULL),(121859,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:47:00','2024-07-05 22:47:02',NULL),(121860,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:48:00','2024-07-05 22:48:02',NULL),(121861,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:49:00','2024-07-05 22:49:02',NULL),(121862,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:50:00','2024-07-05 22:50:02',NULL),(121863,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:51:00','2024-07-05 22:51:02',NULL),(121864,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:33:03','2024-07-05 22:52:00','2024-07-05 22:52:02',NULL),(121954,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(121955,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(121956,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(121957,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(121958,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(121959,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(121960,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(121971,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(121972,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(121973,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(121974,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(121975,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(121976,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(121977,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(121986,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(121987,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(121988,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(121989,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(121990,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(121991,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(121992,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(122001,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(122002,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(122003,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(122004,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(122005,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(122006,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(122007,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(122016,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(122017,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(122018,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(122019,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(122020,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(122021,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(122022,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(122031,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(122032,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(122033,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(122034,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(122035,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(122036,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(122037,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(122046,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(122047,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(122048,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(122049,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(122050,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(122051,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(122052,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(122061,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(122062,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(122063,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(122064,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(122065,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(122066,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(122067,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(122076,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 23:01:00','2024-07-05 22:48:02','2024-07-05 23:01:00',NULL,NULL),(122077,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(122078,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 23:03:00','2024-07-05 22:48:02','2024-07-05 23:03:00',NULL,NULL),(122079,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(122080,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(122081,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(122082,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-05 23:07:00','2024-07-05 22:48:02','2024-07-05 23:07:00',NULL,NULL),(122105,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-05 23:02:00','2024-07-05 22:48:02','2024-07-05 23:02:00',NULL,NULL),(122106,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-05 23:04:00','2024-07-05 22:48:02','2024-07-05 23:04:00',NULL,NULL),(122107,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-05 23:06:00','2024-07-05 22:48:02','2024-07-05 23:06:00',NULL,NULL),(122110,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-05 23:05:00','2024-07-05 22:48:02','2024-07-05 23:05:00',NULL,NULL),(122127,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-05 22:48:02','2024-07-05 23:01:00','2024-07-05 23:01:14',NULL),(122128,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 22:53:00','2024-07-05 22:53:02',NULL),(122129,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 22:54:00','2024-07-05 22:54:02',NULL),(122130,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 22:55:00','2024-07-05 22:55:02',NULL),(122131,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 22:56:00','2024-07-05 22:56:02',NULL),(122132,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 22:57:00','2024-07-05 22:57:02',NULL),(122133,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 22:58:00','2024-07-05 22:58:02',NULL),(122134,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 22:59:00','2024-07-05 22:59:02',NULL),(122135,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:00:00','2024-07-05 23:00:02',NULL),(122136,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:01:00','2024-07-05 23:01:02',NULL),(122137,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:02:00','2024-07-05 23:02:02',NULL),(122138,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:03:00','2024-07-05 23:03:03',NULL),(122139,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:04:00','2024-07-05 23:04:02',NULL),(122140,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:05:00','2024-07-05 23:05:02',NULL),(122141,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:06:00','2024-07-05 23:06:02',NULL),(122142,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 22:48:02','2024-07-05 23:07:00','2024-07-05 23:07:02',NULL),(122450,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:08:00','2024-07-05 23:08:01',NULL),(122451,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:09:00','2024-07-05 23:09:02',NULL),(122452,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:10:00','2024-07-05 23:10:02',NULL),(122453,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:11:00','2024-07-05 23:11:02',NULL),(122454,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:12:00','2024-07-05 23:12:02',NULL),(122455,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:13:00','2024-07-05 23:13:02',NULL),(122456,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:14:00','2024-07-05 23:14:02',NULL),(122457,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:15:00','2024-07-05 23:15:02',NULL),(122458,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:16:00','2024-07-05 23:16:02',NULL),(122459,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:17:00','2024-07-05 23:17:02',NULL),(122460,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:18:00','2024-07-05 23:18:02',NULL),(122461,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:19:00','2024-07-05 23:19:02',NULL),(122462,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:20:00','2024-07-05 23:20:02',NULL),(122463,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:21:00','2024-07-05 23:21:01',NULL),(122464,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:03:03','2024-07-05 23:22:00','2024-07-05 23:22:02',NULL),(122721,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:23:00','2024-07-05 23:23:02',NULL),(122722,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:24:00','2024-07-05 23:24:01',NULL),(122723,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:25:00','2024-07-05 23:25:02',NULL),(122724,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:26:00','2024-07-05 23:26:02',NULL),(122725,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:27:00','2024-07-05 23:27:02',NULL),(122726,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:28:00','2024-07-05 23:28:02',NULL),(122727,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:29:00','2024-07-05 23:29:02',NULL),(122728,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:30:00','2024-07-05 23:30:02',NULL),(122729,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:31:00','2024-07-05 23:31:02',NULL),(122730,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:32:00','2024-07-05 23:32:02',NULL),(122731,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:33:00','2024-07-05 23:33:02',NULL),(122732,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:34:00','2024-07-05 23:34:02',NULL),(122733,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:35:00','2024-07-05 23:35:02',NULL),(122734,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:36:00','2024-07-05 23:36:02',NULL),(122735,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:18:02','2024-07-05 23:37:00','2024-07-05 23:37:01',NULL),(122994,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:38:00','2024-07-05 23:38:02',NULL),(122995,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:39:00','2024-07-05 23:39:02',NULL),(122996,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:40:00','2024-07-05 23:40:02',NULL),(122997,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:41:00','2024-07-05 23:41:02',NULL),(122998,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:42:00','2024-07-05 23:42:02',NULL),(122999,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:43:00','2024-07-05 23:43:02',NULL),(123000,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:44:00','2024-07-05 23:44:02',NULL),(123001,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:45:00','2024-07-05 23:45:02',NULL),(123002,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:46:00','2024-07-05 23:46:02',NULL),(123003,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:47:00','2024-07-05 23:47:02',NULL),(123004,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:48:00','2024-07-05 23:48:03',NULL),(123005,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:49:00','2024-07-05 23:49:02',NULL),(123006,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:50:00','2024-07-05 23:50:02',NULL),(123007,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:51:00','2024-07-05 23:51:02',NULL),(123008,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:33:02','2024-07-05 23:52:00','2024-07-05 23:52:02',NULL),(123097,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123098,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123099,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123100,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123101,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123102,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123103,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123114,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123115,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123116,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123117,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123118,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123119,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123120,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123129,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123130,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123131,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123132,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123133,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123134,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123135,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123144,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123145,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123146,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123147,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123148,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123149,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123150,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123159,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123160,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123161,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123162,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123163,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123164,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123165,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123174,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123175,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123176,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123177,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123178,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123179,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123180,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123189,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123190,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123191,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123192,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123193,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123194,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123195,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123204,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123205,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123206,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123207,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123208,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123209,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123210,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123219,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 00:01:00','2024-07-05 23:48:02','2024-07-06 00:01:00',NULL,NULL),(123220,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123221,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 00:03:00','2024-07-05 23:48:02','2024-07-06 00:03:00',NULL,NULL),(123222,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123223,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123224,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123225,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 00:07:00','2024-07-05 23:48:02','2024-07-06 00:07:00',NULL,NULL),(123248,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 00:02:00','2024-07-05 23:48:02','2024-07-06 00:02:00',NULL,NULL),(123249,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 00:04:00','2024-07-05 23:48:02','2024-07-06 00:04:00',NULL,NULL),(123250,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 00:06:00','2024-07-05 23:48:02','2024-07-06 00:06:00',NULL,NULL),(123253,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 00:05:00','2024-07-05 23:48:02','2024-07-06 00:05:00',NULL,NULL),(123270,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-05 23:48:02','2024-07-06 00:01:00','2024-07-06 00:01:14',NULL),(123271,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-05 23:53:00','2024-07-05 23:53:02',NULL),(123272,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-05 23:54:00','2024-07-05 23:54:02',NULL),(123273,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-05 23:55:00','2024-07-05 23:55:02',NULL),(123274,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-05 23:56:00','2024-07-05 23:56:02',NULL),(123275,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-05 23:57:00','2024-07-05 23:57:02',NULL),(123276,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-05 23:58:00','2024-07-05 23:58:02',NULL),(123277,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-05 23:59:00','2024-07-05 23:59:02',NULL),(123278,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:00:00','2024-07-06 00:00:02',NULL),(123279,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:01:00','2024-07-06 00:01:02',NULL),(123280,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:02:00','2024-07-06 00:02:02',NULL),(123281,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:03:00','2024-07-06 00:03:02',NULL),(123282,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:04:00','2024-07-06 00:04:02',NULL),(123283,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:05:00','2024-07-06 00:05:02',NULL),(123284,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:06:00','2024-07-06 00:06:02',NULL),(123285,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-05 23:48:03','2024-07-06 00:07:00','2024-07-06 00:07:02',NULL),(123591,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:08:00','2024-07-06 00:08:02',NULL),(123592,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:09:00','2024-07-06 00:09:02',NULL),(123593,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:10:00','2024-07-06 00:10:02',NULL),(123594,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:11:00','2024-07-06 00:11:02',NULL),(123595,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:12:00','2024-07-06 00:12:02',NULL),(123596,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:13:00','2024-07-06 00:13:02',NULL),(123597,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:14:00','2024-07-06 00:14:02',NULL),(123598,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:15:00','2024-07-06 00:15:02',NULL),(123599,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:16:00','2024-07-06 00:16:02',NULL),(123600,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:17:00','2024-07-06 00:17:02',NULL),(123601,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:18:00','2024-07-06 00:18:02',NULL),(123602,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:19:00','2024-07-06 00:19:02',NULL),(123603,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:20:00','2024-07-06 00:20:02',NULL),(123604,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:21:00','2024-07-06 00:21:02',NULL),(123605,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:03:02','2024-07-06 00:22:00','2024-07-06 00:22:02',NULL),(123864,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:23:00','2024-07-06 00:23:02',NULL),(123865,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:24:00','2024-07-06 00:24:02',NULL),(123866,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:25:00','2024-07-06 00:25:02',NULL),(123867,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:26:00','2024-07-06 00:26:02',NULL),(123868,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:27:00','2024-07-06 00:27:02',NULL),(123869,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:28:00','2024-07-06 00:28:02',NULL),(123870,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:29:00','2024-07-06 00:29:02',NULL),(123871,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:30:00','2024-07-06 00:30:01',NULL),(123872,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:31:00','2024-07-06 00:31:01',NULL),(123873,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:32:00','2024-07-06 00:32:02',NULL),(123874,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:33:00','2024-07-06 00:33:02',NULL),(123875,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:34:00','2024-07-06 00:34:02',NULL),(123876,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:35:00','2024-07-06 00:35:02',NULL),(123877,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:36:00','2024-07-06 00:36:01',NULL),(123878,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:18:02','2024-07-06 00:37:00','2024-07-06 00:37:02',NULL),(124138,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:38:00','2024-07-06 00:38:02',NULL),(124139,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:39:00','2024-07-06 00:39:02',NULL),(124140,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:40:00','2024-07-06 00:40:02',NULL),(124141,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:41:00','2024-07-06 00:41:02',NULL),(124142,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:42:00','2024-07-06 00:42:02',NULL),(124143,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:43:00','2024-07-06 00:43:02',NULL),(124144,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:44:00','2024-07-06 00:44:02',NULL),(124145,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:45:00','2024-07-06 00:45:02',NULL),(124146,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:46:00','2024-07-06 00:46:02',NULL),(124147,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:47:00','2024-07-06 00:47:02',NULL),(124148,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:48:00','2024-07-06 00:48:02',NULL),(124149,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:49:00','2024-07-06 00:49:02',NULL),(124150,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:50:00','2024-07-06 00:50:02',NULL),(124151,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:51:00','2024-07-06 00:51:02',NULL),(124152,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:33:02','2024-07-06 00:52:00','2024-07-06 00:52:02',NULL),(124241,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124242,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124243,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124244,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124245,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124246,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124247,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124258,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124259,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124260,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124261,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124262,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124263,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124264,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124273,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124274,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124275,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124276,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124277,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124278,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124279,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124288,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124289,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124290,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124291,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124292,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124293,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124294,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124303,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124304,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124305,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124306,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124307,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124308,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124309,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124318,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124319,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124320,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124321,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124322,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124323,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124324,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124333,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124334,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124335,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124336,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124337,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124338,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124339,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124348,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124349,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124350,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124351,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124352,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124353,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124354,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124363,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 01:01:00','2024-07-06 00:48:02','2024-07-06 01:01:00',NULL,NULL),(124364,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124365,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 01:03:00','2024-07-06 00:48:02','2024-07-06 01:03:00',NULL,NULL),(124366,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124367,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124368,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124369,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 01:07:00','2024-07-06 00:48:02','2024-07-06 01:07:00',NULL,NULL),(124392,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 01:02:00','2024-07-06 00:48:02','2024-07-06 01:02:00',NULL,NULL),(124393,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 01:04:00','2024-07-06 00:48:02','2024-07-06 01:04:00',NULL,NULL),(124394,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 01:06:00','2024-07-06 00:48:02','2024-07-06 01:06:00',NULL,NULL),(124397,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 01:05:00','2024-07-06 00:48:02','2024-07-06 01:05:00',NULL,NULL),(124414,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 00:48:02','2024-07-06 01:01:00','2024-07-06 01:01:14',NULL),(124415,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 00:53:00','2024-07-06 00:53:02',NULL),(124416,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 00:54:00','2024-07-06 00:54:02',NULL),(124417,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 00:55:00','2024-07-06 00:55:02',NULL),(124418,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 00:56:00','2024-07-06 00:56:02',NULL),(124419,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 00:57:00','2024-07-06 00:57:02',NULL),(124420,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 00:58:00','2024-07-06 00:58:02',NULL),(124421,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 00:59:00','2024-07-06 00:59:02',NULL),(124422,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:00:00','2024-07-06 01:00:02',NULL),(124423,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:01:00','2024-07-06 01:01:02',NULL),(124424,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:02:00','2024-07-06 01:02:01',NULL),(124425,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:03:00','2024-07-06 01:03:02',NULL),(124426,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:04:00','2024-07-06 01:04:02',NULL),(124427,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:05:00','2024-07-06 01:05:02',NULL),(124428,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:06:00','2024-07-06 01:06:02',NULL),(124429,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 00:48:02','2024-07-06 01:07:00','2024-07-06 01:07:02',NULL),(124735,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:08:00','2024-07-06 01:08:02',NULL),(124736,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:09:00','2024-07-06 01:09:02',NULL),(124737,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:10:00','2024-07-06 01:10:02',NULL),(124738,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:11:00','2024-07-06 01:11:02',NULL),(124739,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:12:00','2024-07-06 01:12:02',NULL),(124740,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:13:00','2024-07-06 01:13:02',NULL),(124741,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:14:00','2024-07-06 01:14:02',NULL),(124742,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:15:00','2024-07-06 01:15:01',NULL),(124743,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:16:00','2024-07-06 01:16:02',NULL),(124744,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:17:00','2024-07-06 01:17:02',NULL),(124745,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:18:00','2024-07-06 01:18:02',NULL),(124746,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:19:00','2024-07-06 01:19:02',NULL),(124747,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:20:00','2024-07-06 01:20:02',NULL),(124748,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:21:00','2024-07-06 01:21:02',NULL),(124749,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:03:02','2024-07-06 01:22:00','2024-07-06 01:22:02',NULL),(125022,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:23:00','2024-07-06 01:23:01',NULL),(125023,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:24:00','2024-07-06 01:24:02',NULL),(125024,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:25:00','2024-07-06 01:25:02',NULL),(125025,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:26:00','2024-07-06 01:26:02',NULL),(125026,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:27:00','2024-07-06 01:27:02',NULL),(125027,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:28:00','2024-07-06 01:28:02',NULL),(125028,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:29:00','2024-07-06 01:29:02',NULL),(125029,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:30:00','2024-07-06 01:30:02',NULL),(125030,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:31:00','2024-07-06 01:31:02',NULL),(125031,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:32:00','2024-07-06 01:32:02',NULL),(125032,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:33:00','2024-07-06 01:33:02',NULL),(125033,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:34:00','2024-07-06 01:34:03',NULL),(125034,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:35:00','2024-07-06 01:35:02',NULL),(125035,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:36:00','2024-07-06 01:36:02',NULL),(125036,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:37:00','2024-07-06 01:37:02',NULL),(125037,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:19:02','2024-07-06 01:38:00','2024-07-06 01:38:02',NULL),(125297,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:39:00','2024-07-06 01:39:02',NULL),(125298,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:40:00','2024-07-06 01:40:02',NULL),(125299,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:41:00','2024-07-06 01:41:02',NULL),(125300,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:42:00','2024-07-06 01:42:02',NULL),(125301,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:43:00','2024-07-06 01:43:02',NULL),(125302,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:44:00','2024-07-06 01:44:02',NULL),(125303,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:45:00','2024-07-06 01:45:02',NULL),(125304,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:46:00','2024-07-06 01:46:02',NULL),(125305,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:47:00','2024-07-06 01:47:02',NULL),(125306,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:48:00','2024-07-06 01:48:02',NULL),(125307,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:49:00','2024-07-06 01:49:02',NULL),(125308,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:50:00','2024-07-06 01:50:02',NULL),(125309,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:51:00','2024-07-06 01:51:02',NULL),(125310,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:52:00','2024-07-06 01:52:02',NULL),(125311,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:34:03','2024-07-06 01:53:00','2024-07-06 01:53:02',NULL),(125399,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125400,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125401,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125402,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125403,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125404,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125405,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125406,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125416,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125417,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125418,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125419,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125420,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125421,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125422,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125423,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125431,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125432,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125433,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125434,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125435,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125436,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125437,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125438,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125446,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125447,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125448,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125449,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125450,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125451,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125452,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125453,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125461,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125462,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125463,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125464,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125465,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125466,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125467,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125468,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125476,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125477,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125478,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125479,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125480,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125481,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125482,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125483,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125491,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125492,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125493,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125494,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125495,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125496,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125497,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125498,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125506,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125507,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125508,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125509,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125510,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125511,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125512,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125513,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125521,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:01:00','2024-07-06 01:49:02','2024-07-06 02:01:00',NULL,NULL),(125522,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125523,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:03:00','2024-07-06 01:49:02','2024-07-06 02:03:00',NULL,NULL),(125524,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125525,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125526,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125527,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:07:00','2024-07-06 01:49:02','2024-07-06 02:07:00',NULL,NULL),(125528,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125551,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 02:02:00','2024-07-06 01:49:02','2024-07-06 02:02:00',NULL,NULL),(125552,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 02:04:00','2024-07-06 01:49:02','2024-07-06 02:04:00',NULL,NULL),(125553,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 02:06:00','2024-07-06 01:49:02','2024-07-06 02:06:00',NULL,NULL),(125554,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 02:08:00','2024-07-06 01:49:02','2024-07-06 02:08:00',NULL,NULL),(125557,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 02:05:00','2024-07-06 01:49:02','2024-07-06 02:05:00',NULL,NULL),(125574,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 01:49:02','2024-07-06 02:01:00','2024-07-06 02:01:15',NULL),(125575,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 01:54:00','2024-07-06 01:54:02',NULL),(125576,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 01:55:00','2024-07-06 01:55:02',NULL),(125577,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 01:56:00','2024-07-06 01:56:02',NULL),(125578,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 01:57:00','2024-07-06 01:57:02',NULL),(125579,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 01:58:00','2024-07-06 01:58:02',NULL),(125580,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 01:59:00','2024-07-06 01:59:02',NULL),(125581,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:00:00','2024-07-06 02:00:02',NULL),(125582,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:01:00','2024-07-06 02:01:02',NULL),(125583,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:02:00','2024-07-06 02:02:02',NULL),(125584,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:03:00','2024-07-06 02:03:02',NULL),(125585,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:04:00','2024-07-06 02:04:03',NULL),(125586,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:05:00','2024-07-06 02:05:02',NULL),(125587,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:06:00','2024-07-06 02:06:02',NULL),(125588,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:07:00','2024-07-06 02:07:02',NULL),(125589,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 01:49:02','2024-07-06 02:08:00','2024-07-06 02:08:02',NULL),(125897,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:09:00','2024-07-06 02:09:02',NULL),(125898,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:10:00','2024-07-06 02:10:02',NULL),(125899,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:11:00','2024-07-06 02:11:02',NULL),(125900,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:12:00','2024-07-06 02:12:02',NULL),(125901,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:13:00','2024-07-06 02:13:02',NULL),(125902,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:14:00','2024-07-06 02:14:02',NULL),(125903,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:15:00','2024-07-06 02:15:02',NULL),(125904,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:16:00','2024-07-06 02:16:02',NULL),(125905,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:17:00','2024-07-06 02:17:02',NULL),(125906,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:18:00','2024-07-06 02:18:01',NULL),(125907,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:19:00','2024-07-06 02:19:02',NULL),(125908,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:20:00','2024-07-06 02:20:02',NULL),(125909,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:02','2024-07-06 02:21:00','2024-07-06 02:21:02',NULL),(125910,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:03','2024-07-06 02:22:00','2024-07-06 02:22:02',NULL),(125911,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:04:03','2024-07-06 02:23:00','2024-07-06 02:23:02',NULL),(126167,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:24:00','2024-07-06 02:24:02',NULL),(126168,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:25:00','2024-07-06 02:25:02',NULL),(126169,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:26:00','2024-07-06 02:26:01',NULL),(126170,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:27:00','2024-07-06 02:27:02',NULL),(126171,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:28:00','2024-07-06 02:28:02',NULL),(126172,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:29:00','2024-07-06 02:29:02',NULL),(126173,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:30:00','2024-07-06 02:30:02',NULL),(126174,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:31:00','2024-07-06 02:31:02',NULL),(126175,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:32:00','2024-07-06 02:32:02',NULL),(126176,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:33:00','2024-07-06 02:33:02',NULL),(126177,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:34:00','2024-07-06 02:34:02',NULL),(126178,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:35:00','2024-07-06 02:35:01',NULL),(126179,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:36:00','2024-07-06 02:36:02',NULL),(126180,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:37:00','2024-07-06 02:37:02',NULL),(126181,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:19:02','2024-07-06 02:38:00','2024-07-06 02:38:02',NULL),(126439,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:39:00','2024-07-06 02:39:02',NULL),(126440,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:40:00','2024-07-06 02:40:02',NULL),(126441,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:41:00','2024-07-06 02:41:02',NULL),(126442,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:42:00','2024-07-06 02:42:02',NULL),(126443,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:43:00','2024-07-06 02:43:02',NULL),(126444,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:44:00','2024-07-06 02:44:02',NULL),(126445,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:45:00','2024-07-06 02:45:02',NULL),(126446,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:46:00','2024-07-06 02:46:02',NULL),(126447,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:47:00','2024-07-06 02:47:02',NULL),(126448,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:48:00','2024-07-06 02:48:01',NULL),(126449,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:49:00','2024-07-06 02:49:02',NULL),(126450,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:50:00','2024-07-06 02:50:02',NULL),(126451,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:51:00','2024-07-06 02:51:02',NULL),(126452,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:52:00','2024-07-06 02:52:02',NULL),(126453,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:34:02','2024-07-06 02:53:00','2024-07-06 02:53:01',NULL),(126541,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126542,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126543,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126544,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126545,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126546,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126547,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126548,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126558,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126559,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126560,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126561,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126562,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126563,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126564,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126565,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126573,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126574,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126575,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126576,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126577,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126578,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126579,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126580,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126588,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126589,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126590,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126591,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126592,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126593,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126594,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126595,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126603,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126604,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126605,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126606,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126607,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126608,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126609,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126610,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126618,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126619,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126620,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126621,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126622,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126623,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126624,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126625,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126633,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126634,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126635,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126636,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126637,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126638,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126639,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126640,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126648,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126649,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126650,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126651,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126652,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126653,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126654,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126655,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126663,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:01:00','2024-07-06 02:49:02','2024-07-06 03:01:00',NULL,NULL),(126664,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126665,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:03:00','2024-07-06 02:49:02','2024-07-06 03:03:00',NULL,NULL),(126666,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126667,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126668,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126669,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:07:00','2024-07-06 02:49:02','2024-07-06 03:07:00',NULL,NULL),(126670,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126693,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 03:02:00','2024-07-06 02:49:02','2024-07-06 03:02:00',NULL,NULL),(126694,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 03:04:00','2024-07-06 02:49:02','2024-07-06 03:04:00',NULL,NULL),(126695,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 03:06:00','2024-07-06 02:49:02','2024-07-06 03:06:00',NULL,NULL),(126696,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 03:08:00','2024-07-06 02:49:02','2024-07-06 03:08:00',NULL,NULL),(126699,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 03:05:00','2024-07-06 02:49:02','2024-07-06 03:05:00',NULL,NULL),(126716,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 02:49:02','2024-07-06 03:01:00','2024-07-06 03:01:15',NULL),(126717,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 02:54:00','2024-07-06 02:54:02',NULL),(126718,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 02:55:00','2024-07-06 02:55:02',NULL),(126719,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 02:56:00','2024-07-06 02:56:01',NULL),(126720,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 02:57:00','2024-07-06 02:57:02',NULL),(126721,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 02:58:00','2024-07-06 02:58:02',NULL),(126722,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 02:59:00','2024-07-06 02:59:01',NULL),(126723,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:00:00','2024-07-06 03:00:02',NULL),(126724,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:01:00','2024-07-06 03:01:02',NULL),(126725,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:02:00','2024-07-06 03:02:02',NULL),(126726,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:03:00','2024-07-06 03:03:02',NULL),(126727,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:04:00','2024-07-06 03:04:03',NULL),(126728,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:05:00','2024-07-06 03:05:02',NULL),(126729,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:06:00','2024-07-06 03:06:02',NULL),(126730,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:07:00','2024-07-06 03:07:02',NULL),(126731,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 02:49:02','2024-07-06 03:08:00','2024-07-06 03:08:02',NULL),(127041,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:09:00','2024-07-06 03:09:01',NULL),(127042,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:10:00','2024-07-06 03:10:02',NULL),(127043,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:11:00','2024-07-06 03:11:02',NULL),(127044,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:12:00','2024-07-06 03:12:01',NULL),(127045,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:13:00','2024-07-06 03:13:02',NULL),(127046,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:14:00','2024-07-06 03:14:02',NULL),(127047,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:15:00','2024-07-06 03:15:02',NULL),(127048,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:16:00','2024-07-06 03:16:02',NULL),(127049,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:17:00','2024-07-06 03:17:02',NULL),(127050,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:18:00','2024-07-06 03:18:02',NULL),(127051,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:19:00','2024-07-06 03:19:02',NULL),(127052,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:20:00','2024-07-06 03:20:02',NULL),(127053,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:21:00','2024-07-06 03:21:02',NULL),(127054,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:22:00','2024-07-06 03:22:02',NULL),(127055,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:04:03','2024-07-06 03:23:00','2024-07-06 03:23:01',NULL),(127311,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:24:00','2024-07-06 03:24:02',NULL),(127312,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:25:00','2024-07-06 03:25:02',NULL),(127313,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:26:00','2024-07-06 03:26:01',NULL),(127314,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:27:00','2024-07-06 03:27:02',NULL),(127315,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:28:00','2024-07-06 03:28:02',NULL),(127316,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:29:00','2024-07-06 03:29:02',NULL),(127317,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:30:00','2024-07-06 03:30:02',NULL),(127318,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:31:00','2024-07-06 03:31:02',NULL),(127319,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:32:00','2024-07-06 03:32:02',NULL),(127320,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:33:00','2024-07-06 03:33:02',NULL),(127321,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:34:00','2024-07-06 03:34:02',NULL),(127322,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:35:00','2024-07-06 03:35:02',NULL),(127323,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:36:00','2024-07-06 03:36:02',NULL),(127324,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:37:00','2024-07-06 03:37:02',NULL),(127325,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:19:02','2024-07-06 03:38:00','2024-07-06 03:38:02',NULL),(127585,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:39:00','2024-07-06 03:39:02',NULL),(127586,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:40:00','2024-07-06 03:40:02',NULL),(127587,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:41:00','2024-07-06 03:41:01',NULL),(127588,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:42:00','2024-07-06 03:42:02',NULL),(127589,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:43:00','2024-07-06 03:43:02',NULL),(127590,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:44:00','2024-07-06 03:44:01',NULL),(127591,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:45:00','2024-07-06 03:45:02',NULL),(127592,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:46:00','2024-07-06 03:46:02',NULL),(127593,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:47:00','2024-07-06 03:47:01',NULL),(127594,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:48:00','2024-07-06 03:48:02',NULL),(127595,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:49:00','2024-07-06 03:49:02',NULL),(127596,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:50:00','2024-07-06 03:50:02',NULL),(127597,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:51:00','2024-07-06 03:51:02',NULL),(127598,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:52:00','2024-07-06 03:52:02',NULL),(127599,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:34:02','2024-07-06 03:53:00','2024-07-06 03:53:02',NULL),(127687,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127688,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127689,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127690,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127691,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127692,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127693,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127694,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127704,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127705,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127706,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127707,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127708,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127709,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127710,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127711,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127719,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127720,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127721,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127722,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127723,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127724,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127725,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127726,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127734,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127735,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127736,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127737,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127738,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127739,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127740,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127741,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127749,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127750,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127751,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127752,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127753,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127754,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127755,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127756,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127764,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127765,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127766,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127767,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127768,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127769,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127770,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127771,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127779,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127780,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127781,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127782,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127783,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127784,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127785,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127786,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127794,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127795,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127796,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127797,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127798,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127799,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127800,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127801,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127809,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:01:00','2024-07-06 03:49:02','2024-07-06 04:01:00',NULL,NULL),(127810,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127811,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:03:00','2024-07-06 03:49:02','2024-07-06 04:03:00',NULL,NULL),(127812,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127813,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127814,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127815,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:07:00','2024-07-06 03:49:02','2024-07-06 04:07:00',NULL,NULL),(127816,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127839,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 04:02:00','2024-07-06 03:49:02','2024-07-06 04:02:00',NULL,NULL),(127840,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 04:04:00','2024-07-06 03:49:02','2024-07-06 04:04:00',NULL,NULL),(127841,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 04:06:00','2024-07-06 03:49:02','2024-07-06 04:06:00',NULL,NULL),(127842,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 04:08:00','2024-07-06 03:49:02','2024-07-06 04:08:00',NULL,NULL),(127845,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 04:05:00','2024-07-06 03:49:02','2024-07-06 04:05:00',NULL,NULL),(127862,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 03:49:02','2024-07-06 04:01:00','2024-07-06 04:01:15',NULL),(127863,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 03:54:00','2024-07-06 03:54:02',NULL),(127864,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 03:55:00','2024-07-06 03:55:02',NULL),(127865,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 03:56:00','2024-07-06 03:56:02',NULL),(127866,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 03:57:00','2024-07-06 03:57:02',NULL),(127867,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 03:58:00','2024-07-06 03:58:02',NULL),(127868,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 03:59:00','2024-07-06 03:59:02',NULL),(127869,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:00:00','2024-07-06 04:00:02',NULL),(127870,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:01:00','2024-07-06 04:01:02',NULL),(127871,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:02:00','2024-07-06 04:02:02',NULL),(127872,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:03:00','2024-07-06 04:03:02',NULL),(127873,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:04:00','2024-07-06 04:04:03',NULL),(127874,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:05:00','2024-07-06 04:05:02',NULL),(127875,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:06:00','2024-07-06 04:06:02',NULL),(127876,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:07:00','2024-07-06 04:07:02',NULL),(127877,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 03:49:02','2024-07-06 04:08:00','2024-07-06 04:08:02',NULL),(128185,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:09:00','2024-07-06 04:09:02',NULL),(128186,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:10:00','2024-07-06 04:10:02',NULL),(128187,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:11:00','2024-07-06 04:11:02',NULL),(128188,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:12:00','2024-07-06 04:12:02',NULL),(128189,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:13:00','2024-07-06 04:13:02',NULL),(128190,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:14:00','2024-07-06 04:14:02',NULL),(128191,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:15:00','2024-07-06 04:15:01',NULL),(128192,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:16:00','2024-07-06 04:16:02',NULL),(128193,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:17:00','2024-07-06 04:17:02',NULL),(128194,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:18:00','2024-07-06 04:18:01',NULL),(128195,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:19:00','2024-07-06 04:19:02',NULL),(128196,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:20:00','2024-07-06 04:20:02',NULL),(128197,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:21:00','2024-07-06 04:21:02',NULL),(128198,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:22:00','2024-07-06 04:22:02',NULL),(128199,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:04:03','2024-07-06 04:23:00','2024-07-06 04:23:02',NULL),(128455,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:24:00','2024-07-06 04:24:02',NULL),(128456,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:25:00','2024-07-06 04:25:02',NULL),(128457,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:26:00','2024-07-06 04:26:02',NULL),(128458,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:27:00','2024-07-06 04:27:02',NULL),(128459,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:28:00','2024-07-06 04:28:02',NULL),(128460,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:29:00','2024-07-06 04:29:02',NULL),(128461,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:30:00','2024-07-06 04:30:02',NULL),(128462,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:31:00','2024-07-06 04:31:02',NULL),(128463,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:32:00','2024-07-06 04:32:02',NULL),(128464,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:33:00','2024-07-06 04:33:02',NULL),(128465,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:34:00','2024-07-06 04:34:03',NULL),(128466,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:35:00','2024-07-06 04:35:01',NULL),(128467,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:36:00','2024-07-06 04:36:02',NULL),(128468,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:37:00','2024-07-06 04:37:02',NULL),(128469,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:19:02','2024-07-06 04:38:00','2024-07-06 04:38:02',NULL),(128729,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:39:00','2024-07-06 04:39:02',NULL),(128730,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:40:00','2024-07-06 04:40:02',NULL),(128731,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:41:00','2024-07-06 04:41:02',NULL),(128732,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:42:00','2024-07-06 04:42:02',NULL),(128733,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:43:00','2024-07-06 04:43:02',NULL),(128734,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:44:00','2024-07-06 04:44:02',NULL),(128735,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:45:00','2024-07-06 04:45:02',NULL),(128736,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:46:00','2024-07-06 04:46:02',NULL),(128737,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:47:00','2024-07-06 04:47:02',NULL),(128738,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:48:00','2024-07-06 04:48:02',NULL),(128739,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:49:00','2024-07-06 04:49:02',NULL),(128740,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:50:00','2024-07-06 04:50:02',NULL),(128741,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:51:00','2024-07-06 04:51:02',NULL),(128742,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:52:00','2024-07-06 04:52:02',NULL),(128743,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:34:03','2024-07-06 04:53:00','2024-07-06 04:53:02',NULL),(128835,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128836,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128837,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128838,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128839,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128840,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128841,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128842,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128857,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128858,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128859,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128860,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128861,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128862,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128863,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128864,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128872,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128873,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128874,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128875,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128876,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128877,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128878,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128879,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128887,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128888,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128889,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128890,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128891,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128892,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128893,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128894,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128902,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128903,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128904,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128905,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128906,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128907,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128908,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128909,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128917,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128918,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128919,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128920,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128921,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128922,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128923,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128924,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128932,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128933,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128934,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128935,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128936,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128937,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128938,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128939,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128947,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128948,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128949,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128950,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128951,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128952,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128953,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128954,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128962,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:01:00','2024-07-06 04:49:02','2024-07-06 05:01:00',NULL,NULL),(128963,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128964,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:03:00','2024-07-06 04:49:02','2024-07-06 05:03:00',NULL,NULL),(128965,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128966,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(128967,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128968,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:07:00','2024-07-06 04:49:02','2024-07-06 05:07:00',NULL,NULL),(128969,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(128995,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 05:02:00','2024-07-06 04:49:02','2024-07-06 05:02:00',NULL,NULL),(128996,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 05:04:00','2024-07-06 04:49:02','2024-07-06 05:04:00',NULL,NULL),(128997,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 05:06:00','2024-07-06 04:49:02','2024-07-06 05:06:00',NULL,NULL),(128998,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 05:08:00','2024-07-06 04:49:02','2024-07-06 05:08:00',NULL,NULL),(129001,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 05:05:00','2024-07-06 04:49:02','2024-07-06 05:05:00',NULL,NULL),(129022,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 04:49:02','2024-07-06 05:01:00','2024-07-06 05:01:14',NULL),(129024,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 04:54:00','2024-07-06 04:54:02',NULL),(129025,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 04:55:00','2024-07-06 04:55:02',NULL),(129026,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 04:56:00','2024-07-06 04:56:02',NULL),(129027,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 04:57:00','2024-07-06 04:57:02',NULL),(129028,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 04:58:00','2024-07-06 04:58:02',NULL),(129029,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 04:59:00','2024-07-06 04:59:02',NULL),(129030,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:00:00','2024-07-06 05:00:02',NULL),(129031,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:01:00','2024-07-06 05:01:02',NULL),(129032,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:02:00','2024-07-06 05:02:02',NULL),(129033,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:03:00','2024-07-06 05:03:01',NULL),(129034,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:04:00','2024-07-06 05:04:02',NULL),(129035,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:05:00','2024-07-06 05:05:02',NULL),(129036,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:06:00','2024-07-06 05:06:02',NULL),(129037,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:07:00','2024-07-06 05:07:02',NULL),(129038,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 04:49:02','2024-07-06 05:08:00','2024-07-06 05:08:02',NULL),(129344,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:09:00','2024-07-06 05:09:02',NULL),(129345,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:10:00','2024-07-06 05:10:02',NULL),(129346,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:11:00','2024-07-06 05:11:02',NULL),(129347,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:12:00','2024-07-06 05:12:02',NULL),(129348,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:13:00','2024-07-06 05:13:02',NULL),(129349,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:14:00','2024-07-06 05:14:02',NULL),(129350,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:15:00','2024-07-06 05:15:02',NULL),(129351,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:16:00','2024-07-06 05:16:02',NULL),(129352,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:17:00','2024-07-06 05:17:02',NULL),(129353,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:18:00','2024-07-06 05:18:02',NULL),(129354,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:19:00','2024-07-06 05:19:03',NULL),(129355,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:20:00','2024-07-06 05:20:02',NULL),(129356,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:21:00','2024-07-06 05:21:02',NULL),(129357,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:22:00','2024-07-06 05:22:02',NULL),(129358,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:04:02','2024-07-06 05:23:00','2024-07-06 05:23:02',NULL),(129618,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:24:00','2024-07-06 05:24:02',NULL),(129619,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:25:00','2024-07-06 05:25:02',NULL),(129620,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:26:00','2024-07-06 05:26:02',NULL),(129621,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:27:00','2024-07-06 05:27:02',NULL),(129622,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:28:00','2024-07-06 05:28:02',NULL),(129623,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:29:00','2024-07-06 05:29:02',NULL),(129624,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:30:00','2024-07-06 05:30:02',NULL),(129625,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:31:00','2024-07-06 05:31:02',NULL),(129626,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:32:00','2024-07-06 05:32:02',NULL),(129627,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:33:00','2024-07-06 05:33:02',NULL),(129628,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:34:00','2024-07-06 05:34:02',NULL),(129629,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:35:00','2024-07-06 05:35:02',NULL),(129630,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:36:00','2024-07-06 05:36:01',NULL),(129631,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:02','2024-07-06 05:37:00','2024-07-06 05:37:02',NULL),(129632,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:19:03','2024-07-06 05:38:00','2024-07-06 05:38:02',NULL),(129890,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:39:00','2024-07-06 05:39:02',NULL),(129891,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:40:00','2024-07-06 05:40:02',NULL),(129892,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:41:00','2024-07-06 05:41:02',NULL),(129893,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:42:00','2024-07-06 05:42:02',NULL),(129894,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:43:00','2024-07-06 05:43:02',NULL),(129895,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:44:00','2024-07-06 05:44:02',NULL),(129896,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:45:00','2024-07-06 05:45:02',NULL),(129897,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:46:00','2024-07-06 05:46:02',NULL),(129898,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:47:00','2024-07-06 05:47:02',NULL),(129899,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:48:00','2024-07-06 05:48:02',NULL),(129900,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:49:00','2024-07-06 05:49:02',NULL),(129901,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:50:00','2024-07-06 05:50:02',NULL),(129902,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:51:00','2024-07-06 05:51:02',NULL),(129903,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:52:00','2024-07-06 05:52:02',NULL),(129904,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:34:02','2024-07-06 05:53:00','2024-07-06 05:53:02',NULL),(129993,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(129994,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(129995,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(129996,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(129997,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(129998,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(129999,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130000,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130010,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130011,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130012,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130013,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130014,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130015,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130016,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130017,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130025,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130026,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130027,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130028,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130029,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130030,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130031,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130032,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130040,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130041,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130042,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130043,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130044,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130045,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130046,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130047,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130055,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130056,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130057,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130058,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130059,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130060,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130061,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130062,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130070,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130071,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130072,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130073,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130074,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130075,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130076,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130077,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130085,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130086,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130087,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130088,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130089,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130090,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130091,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130092,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130100,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130101,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130102,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130103,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130104,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130105,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130106,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130107,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130115,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:01:00','2024-07-06 05:49:02','2024-07-06 06:01:00',NULL,NULL),(130116,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130117,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:03:00','2024-07-06 05:49:02','2024-07-06 06:03:00',NULL,NULL),(130118,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130119,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130120,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130121,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:07:00','2024-07-06 05:49:02','2024-07-06 06:07:00',NULL,NULL),(130122,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130145,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 06:02:00','2024-07-06 05:49:02','2024-07-06 06:02:00',NULL,NULL),(130146,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 06:04:00','2024-07-06 05:49:02','2024-07-06 06:04:00',NULL,NULL),(130147,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 06:06:00','2024-07-06 05:49:02','2024-07-06 06:06:00',NULL,NULL),(130148,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 06:08:00','2024-07-06 05:49:02','2024-07-06 06:08:00',NULL,NULL),(130151,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 06:05:00','2024-07-06 05:49:02','2024-07-06 06:05:00',NULL,NULL),(130168,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 05:49:02','2024-07-06 06:01:00','2024-07-06 06:01:15',NULL),(130169,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 05:54:00','2024-07-06 05:54:02',NULL),(130170,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 05:55:00','2024-07-06 05:55:02',NULL),(130171,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 05:56:00','2024-07-06 05:56:02',NULL),(130172,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 05:57:00','2024-07-06 05:57:02',NULL),(130173,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 05:58:00','2024-07-06 05:58:02',NULL),(130174,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 05:59:00','2024-07-06 05:59:02',NULL),(130175,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:00:00','2024-07-06 06:00:02',NULL),(130176,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:01:00','2024-07-06 06:01:02',NULL),(130177,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:02:00','2024-07-06 06:02:02',NULL),(130178,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:03:00','2024-07-06 06:03:02',NULL),(130179,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:04:00','2024-07-06 06:04:03',NULL),(130180,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:05:00','2024-07-06 06:05:02',NULL),(130181,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:06:00','2024-07-06 06:06:02',NULL),(130182,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:07:00','2024-07-06 06:07:02',NULL),(130183,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 05:49:02','2024-07-06 06:08:00','2024-07-06 06:08:02',NULL),(130491,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:09:00','2024-07-06 06:09:02',NULL),(130492,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:10:00','2024-07-06 06:10:02',NULL),(130493,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:11:00','2024-07-06 06:11:02',NULL),(130494,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:12:00','2024-07-06 06:12:02',NULL),(130495,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:13:00','2024-07-06 06:13:02',NULL),(130496,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:14:00','2024-07-06 06:14:02',NULL),(130497,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:15:00','2024-07-06 06:15:02',NULL),(130498,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:16:00','2024-07-06 06:16:02',NULL),(130499,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:17:00','2024-07-06 06:17:02',NULL),(130500,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:18:00','2024-07-06 06:18:02',NULL),(130501,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:19:00','2024-07-06 06:19:02',NULL),(130502,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:20:00','2024-07-06 06:20:02',NULL),(130503,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:21:00','2024-07-06 06:21:02',NULL),(130504,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:22:00','2024-07-06 06:22:02',NULL),(130505,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:04:03','2024-07-06 06:23:00','2024-07-06 06:23:02',NULL),(130763,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:24:00','2024-07-06 06:24:02',NULL),(130764,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:25:00','2024-07-06 06:25:02',NULL),(130765,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:26:00','2024-07-06 06:26:02',NULL),(130766,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:27:00','2024-07-06 06:27:02',NULL),(130767,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:28:00','2024-07-06 06:28:02',NULL),(130768,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:29:00','2024-07-06 06:29:02',NULL),(130769,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:30:00','2024-07-06 06:30:02',NULL),(130770,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:31:00','2024-07-06 06:31:02',NULL),(130771,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:32:00','2024-07-06 06:32:02',NULL),(130772,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:33:00','2024-07-06 06:33:02',NULL),(130773,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:34:00','2024-07-06 06:34:02',NULL),(130774,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:35:00','2024-07-06 06:35:02',NULL),(130775,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:36:00','2024-07-06 06:36:02',NULL),(130776,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:37:00','2024-07-06 06:37:02',NULL),(130777,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:19:02','2024-07-06 06:38:00','2024-07-06 06:38:02',NULL),(131035,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:39:00','2024-07-06 06:39:02',NULL),(131036,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:40:00','2024-07-06 06:40:02',NULL),(131037,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:41:00','2024-07-06 06:41:02',NULL),(131038,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:42:00','2024-07-06 06:42:02',NULL),(131039,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:43:00','2024-07-06 06:43:02',NULL),(131040,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:44:00','2024-07-06 06:44:02',NULL),(131041,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:45:00','2024-07-06 06:45:02',NULL),(131042,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:46:00','2024-07-06 06:46:02',NULL),(131043,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:47:00','2024-07-06 06:47:02',NULL),(131044,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:48:00','2024-07-06 06:48:02',NULL),(131045,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:49:00','2024-07-06 06:49:02',NULL),(131046,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:50:00','2024-07-06 06:50:02',NULL),(131047,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:51:00','2024-07-06 06:51:02',NULL),(131048,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:52:00','2024-07-06 06:52:02',NULL),(131049,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:34:02','2024-07-06 06:53:00','2024-07-06 06:53:02',NULL),(131137,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131138,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131139,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131140,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131141,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131142,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131143,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131144,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131154,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131155,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131156,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131157,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131158,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131159,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131160,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131161,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131169,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131170,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131171,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131172,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131173,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131174,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131175,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131176,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131184,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131185,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131186,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131187,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131188,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131189,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131190,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131191,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131199,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131200,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131201,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131202,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131203,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131204,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131205,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131206,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131214,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131215,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131216,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131217,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131218,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131219,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131220,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131221,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131229,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131230,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131231,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131232,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131233,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131234,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131235,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131236,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131244,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131245,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131246,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131247,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131248,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131249,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131250,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131251,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131259,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:01:00','2024-07-06 06:49:02','2024-07-06 07:01:00',NULL,NULL),(131260,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131261,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:03:00','2024-07-06 06:49:02','2024-07-06 07:03:00',NULL,NULL),(131262,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131263,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131264,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131265,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:07:00','2024-07-06 06:49:02','2024-07-06 07:07:00',NULL,NULL),(131266,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131290,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 07:02:00','2024-07-06 06:49:02','2024-07-06 07:02:00',NULL,NULL),(131291,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 07:04:00','2024-07-06 06:49:02','2024-07-06 07:04:00',NULL,NULL),(131292,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 07:06:00','2024-07-06 06:49:02','2024-07-06 07:06:00',NULL,NULL),(131293,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 07:08:00','2024-07-06 06:49:02','2024-07-06 07:08:00',NULL,NULL),(131296,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 07:05:00','2024-07-06 06:49:02','2024-07-06 07:05:00',NULL,NULL),(131313,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 06:49:02','2024-07-06 07:01:00','2024-07-06 07:01:14',NULL),(131314,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 06:54:00','2024-07-06 06:54:02',NULL),(131315,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 06:55:00','2024-07-06 06:55:02',NULL),(131316,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 06:56:00','2024-07-06 06:56:02',NULL),(131317,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 06:57:00','2024-07-06 06:57:02',NULL),(131318,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 06:58:00','2024-07-06 06:58:02',NULL),(131319,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 06:59:00','2024-07-06 06:59:02',NULL),(131320,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:00:00','2024-07-06 07:00:02',NULL),(131321,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:01:00','2024-07-06 07:01:02',NULL),(131322,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:02:00','2024-07-06 07:02:02',NULL),(131323,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:03:00','2024-07-06 07:03:02',NULL),(131324,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:04:00','2024-07-06 07:04:02',NULL),(131325,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:05:00','2024-07-06 07:05:02',NULL),(131326,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:06:00','2024-07-06 07:06:02',NULL),(131327,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:07:00','2024-07-06 07:07:02',NULL),(131328,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 06:49:02','2024-07-06 07:08:00','2024-07-06 07:08:02',NULL),(131636,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:09:00','2024-07-06 07:09:02',NULL),(131637,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:10:00','2024-07-06 07:10:02',NULL),(131638,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:11:00','2024-07-06 07:11:02',NULL),(131639,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:12:00','2024-07-06 07:12:02',NULL),(131640,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:13:00','2024-07-06 07:13:02',NULL),(131641,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:14:00','2024-07-06 07:14:02',NULL),(131642,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:15:00','2024-07-06 07:15:02',NULL),(131643,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:16:00','2024-07-06 07:16:02',NULL),(131644,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:17:00','2024-07-06 07:17:02',NULL),(131645,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:18:00','2024-07-06 07:18:02',NULL),(131646,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:19:00','2024-07-06 07:19:02',NULL),(131647,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:20:00','2024-07-06 07:20:02',NULL),(131648,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:21:00','2024-07-06 07:21:02',NULL),(131649,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:22:00','2024-07-06 07:22:02',NULL),(131650,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:04:02','2024-07-06 07:23:00','2024-07-06 07:23:02',NULL),(131909,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:24:00','2024-07-06 07:24:02',NULL),(131910,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:25:00','2024-07-06 07:25:02',NULL),(131911,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:26:00','2024-07-06 07:26:02',NULL),(131912,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:27:00','2024-07-06 07:27:02',NULL),(131913,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:28:00','2024-07-06 07:28:02',NULL),(131914,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:29:00','2024-07-06 07:29:02',NULL),(131915,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:30:00','2024-07-06 07:30:02',NULL),(131916,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:31:00','2024-07-06 07:31:02',NULL),(131917,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:32:00','2024-07-06 07:32:02',NULL),(131918,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:33:00','2024-07-06 07:33:02',NULL),(131919,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:34:00','2024-07-06 07:34:02',NULL),(131920,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:35:00','2024-07-06 07:35:03',NULL),(131921,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:36:00','2024-07-06 07:36:02',NULL),(131922,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:37:00','2024-07-06 07:37:02',NULL),(131923,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:19:02','2024-07-06 07:38:00','2024-07-06 07:38:02',NULL),(132179,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:39:00','2024-07-06 07:39:02',NULL),(132180,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:40:00','2024-07-06 07:40:02',NULL),(132181,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:41:00','2024-07-06 07:41:02',NULL),(132182,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:42:00','2024-07-06 07:42:02',NULL),(132183,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:43:00','2024-07-06 07:43:02',NULL),(132184,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:44:00','2024-07-06 07:44:01',NULL),(132185,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:45:00','2024-07-06 07:45:02',NULL),(132186,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:46:00','2024-07-06 07:46:02',NULL),(132187,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:47:00','2024-07-06 07:47:02',NULL),(132188,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:48:00','2024-07-06 07:48:02',NULL),(132189,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:49:00','2024-07-06 07:49:02',NULL),(132190,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:50:00','2024-07-06 07:50:02',NULL),(132191,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:51:00','2024-07-06 07:51:02',NULL),(132192,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:52:00','2024-07-06 07:52:02',NULL),(132193,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:34:02','2024-07-06 07:53:00','2024-07-06 07:53:02',NULL),(132283,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132284,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132285,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132286,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132287,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132288,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132289,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132290,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132300,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132301,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132302,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132303,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132304,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132305,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132306,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132307,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132315,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132316,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132317,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132318,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132319,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132320,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132321,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132322,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132330,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132331,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132332,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132333,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132334,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132335,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132336,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132337,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132345,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132346,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132347,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132348,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132349,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132350,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132351,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132352,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132360,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132361,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132362,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132363,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132364,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132365,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132366,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132367,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132375,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132376,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132377,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132378,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132379,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132380,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132381,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132382,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132390,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132391,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132392,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132393,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132394,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132395,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132396,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132397,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132405,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:01:00','2024-07-06 07:49:02','2024-07-06 08:01:00',NULL,NULL),(132406,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132407,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:03:00','2024-07-06 07:49:02','2024-07-06 08:03:00',NULL,NULL),(132408,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132409,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132410,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132411,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:07:00','2024-07-06 07:49:02','2024-07-06 08:07:00',NULL,NULL),(132412,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132435,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 08:02:00','2024-07-06 07:49:02','2024-07-06 08:02:00',NULL,NULL),(132436,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 08:04:00','2024-07-06 07:49:02','2024-07-06 08:04:00',NULL,NULL),(132437,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 08:06:00','2024-07-06 07:49:02','2024-07-06 08:06:00',NULL,NULL),(132438,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 08:08:00','2024-07-06 07:49:02','2024-07-06 08:08:00',NULL,NULL),(132441,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 08:05:00','2024-07-06 07:49:02','2024-07-06 08:05:00',NULL,NULL),(132458,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 07:49:02','2024-07-06 08:01:00','2024-07-06 08:01:14',NULL),(132459,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 07:54:00','2024-07-06 07:54:02',NULL),(132460,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 07:55:00','2024-07-06 07:55:02',NULL),(132461,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 07:56:00','2024-07-06 07:56:02',NULL),(132462,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 07:57:00','2024-07-06 07:57:02',NULL),(132463,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 07:58:00','2024-07-06 07:58:02',NULL),(132464,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 07:59:00','2024-07-06 07:59:02',NULL),(132465,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:00:00','2024-07-06 08:00:02',NULL),(132466,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:01:00','2024-07-06 08:01:01',NULL),(132467,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:02:00','2024-07-06 08:02:02',NULL),(132468,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:03:00','2024-07-06 08:03:02',NULL),(132469,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:04:00','2024-07-06 08:04:02',NULL),(132470,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:05:00','2024-07-06 08:05:02',NULL),(132471,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:06:00','2024-07-06 08:06:02',NULL),(132472,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:07:00','2024-07-06 08:07:02',NULL),(132473,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 07:49:02','2024-07-06 08:08:00','2024-07-06 08:08:02',NULL),(132782,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:09:00','2024-07-06 08:09:02',NULL),(132783,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:10:00','2024-07-06 08:10:02',NULL),(132784,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:11:00','2024-07-06 08:11:02',NULL),(132785,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:12:00','2024-07-06 08:12:02',NULL),(132786,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:13:00','2024-07-06 08:13:02',NULL),(132787,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:14:00','2024-07-06 08:14:02',NULL),(132788,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:15:00','2024-07-06 08:15:02',NULL),(132789,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:16:00','2024-07-06 08:16:02',NULL),(132790,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:17:00','2024-07-06 08:17:02',NULL),(132791,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:18:00','2024-07-06 08:18:02',NULL),(132792,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:19:00','2024-07-06 08:19:03',NULL),(132793,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:20:00','2024-07-06 08:20:02',NULL),(132794,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:21:00','2024-07-06 08:21:02',NULL),(132795,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:22:00','2024-07-06 08:22:02',NULL),(132796,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:04:02','2024-07-06 08:23:00','2024-07-06 08:23:02',NULL),(133054,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:24:00','2024-07-06 08:24:02',NULL),(133055,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:25:00','2024-07-06 08:25:02',NULL),(133056,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:26:00','2024-07-06 08:26:02',NULL),(133057,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:27:00','2024-07-06 08:27:02',NULL),(133058,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:28:00','2024-07-06 08:28:02',NULL),(133059,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:29:00','2024-07-06 08:29:02',NULL),(133060,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:30:00','2024-07-06 08:30:02',NULL),(133061,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:31:00','2024-07-06 08:31:02',NULL),(133062,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:32:00','2024-07-06 08:32:02',NULL),(133063,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:33:00','2024-07-06 08:33:02',NULL),(133064,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:34:00','2024-07-06 08:34:02',NULL),(133065,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:35:00','2024-07-06 08:35:02',NULL),(133066,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:36:00','2024-07-06 08:36:02',NULL),(133067,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:37:00','2024-07-06 08:37:02',NULL),(133068,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:19:03','2024-07-06 08:38:00','2024-07-06 08:38:02',NULL),(133326,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:39:00','2024-07-06 08:39:02',NULL),(133327,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:40:00','2024-07-06 08:40:02',NULL),(133328,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:41:00','2024-07-06 08:41:02',NULL),(133329,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:42:00','2024-07-06 08:42:02',NULL),(133330,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:43:00','2024-07-06 08:43:02',NULL),(133331,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:44:00','2024-07-06 08:44:02',NULL),(133332,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:45:00','2024-07-06 08:45:01',NULL),(133333,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:46:00','2024-07-06 08:46:02',NULL),(133334,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:47:00','2024-07-06 08:47:02',NULL),(133335,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:48:00','2024-07-06 08:48:02',NULL),(133336,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:49:00','2024-07-06 08:49:03',NULL),(133337,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:50:00','2024-07-06 08:50:02',NULL),(133338,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:51:00','2024-07-06 08:51:02',NULL),(133339,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:52:00','2024-07-06 08:52:02',NULL),(133340,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:34:02','2024-07-06 08:53:00','2024-07-06 08:53:02',NULL),(133428,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133429,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133430,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133431,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133432,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133433,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133434,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133435,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133445,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133446,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133447,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133448,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133449,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133450,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133451,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133452,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133460,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133461,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133462,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133463,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133464,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133465,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133466,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133467,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133475,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133476,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133477,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133478,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133479,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133480,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133481,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133482,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133490,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133491,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133492,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133493,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133494,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133495,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133496,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133497,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133505,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133506,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133507,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133508,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133509,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133510,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133511,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133512,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133520,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133521,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133522,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133523,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133524,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133525,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133526,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133527,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133535,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133536,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133537,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133538,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133539,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133540,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133541,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133542,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133550,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:01:00','2024-07-06 08:49:02','2024-07-06 09:01:00',NULL,NULL),(133551,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:02:00','2024-07-06 08:49:02','2024-07-06 09:02:00',NULL,NULL),(133552,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:03:00','2024-07-06 08:49:02','2024-07-06 09:03:00',NULL,NULL),(133553,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:04:00','2024-07-06 08:49:02','2024-07-06 09:04:00',NULL,NULL),(133554,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:05:00','2024-07-06 08:49:02','2024-07-06 09:05:00',NULL,NULL),(133555,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:06:00','2024-07-06 08:49:02','2024-07-06 09:06:00',NULL,NULL),(133556,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:07:00','2024-07-06 08:49:02','2024-07-06 09:07:00',NULL,NULL),(133557,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 09:08:00','2024-07-06 08:49:02','2024-07-06 09:08:00',NULL,NULL),(133580,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 09:02:00','2024-07-06 08:49:03','2024-07-06 09:02:00',NULL,NULL),(133581,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 09:04:00','2024-07-06 08:49:03','2024-07-06 09:04:00',NULL,NULL),(133582,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 09:06:00','2024-07-06 08:49:03','2024-07-06 09:06:00',NULL,NULL),(133583,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 09:08:00','2024-07-06 08:49:03','2024-07-06 09:08:00',NULL,NULL),(133586,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 09:05:00','2024-07-06 08:49:03','2024-07-06 09:05:00',NULL,NULL),(133603,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 08:49:03','2024-07-06 09:01:00','2024-07-06 09:01:14',NULL),(133604,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 08:54:00','2024-07-06 08:54:02',NULL),(133605,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 08:55:00','2024-07-06 08:55:02',NULL),(133606,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 08:56:00','2024-07-06 08:56:02',NULL),(133607,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 08:57:00','2024-07-06 08:57:02',NULL),(133608,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 08:58:00','2024-07-06 08:58:02',NULL),(133609,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 08:59:00','2024-07-06 08:59:02',NULL),(133610,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:00:00','2024-07-06 09:00:02',NULL),(133611,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:01:00','2024-07-06 09:01:02',NULL),(133612,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:02:00','2024-07-06 09:02:02',NULL),(133613,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:03:00','2024-07-06 09:03:02',NULL),(133614,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:04:00','2024-07-06 09:04:02',NULL),(133615,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:05:00','2024-07-06 09:05:02',NULL),(133616,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:06:00','2024-07-06 09:06:02',NULL),(133617,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:07:00','2024-07-06 09:07:02',NULL),(133618,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 08:49:03','2024-07-06 09:08:00','2024-07-06 09:08:02',NULL),(133926,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:09:00','2024-07-06 09:09:02',NULL),(133927,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:10:00','2024-07-06 09:10:02',NULL),(133928,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:11:00','2024-07-06 09:11:02',NULL),(133929,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:12:00','2024-07-06 09:12:02',NULL),(133930,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:13:00','2024-07-06 09:13:02',NULL),(133931,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:14:00','2024-07-06 09:14:02',NULL),(133932,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:15:00','2024-07-06 09:15:02',NULL),(133933,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:16:00','2024-07-06 09:16:02',NULL),(133934,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:17:00','2024-07-06 09:17:02',NULL),(133935,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:18:00','2024-07-06 09:18:02',NULL),(133936,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:19:00','2024-07-06 09:19:02',NULL),(133937,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:20:00','2024-07-06 09:20:02',NULL),(133938,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:21:00','2024-07-06 09:21:02',NULL),(133939,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:22:00','2024-07-06 09:22:02',NULL),(133940,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:04:02','2024-07-06 09:23:00','2024-07-06 09:23:02',NULL),(134198,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:24:00','2024-07-06 09:24:02',NULL),(134199,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:25:00','2024-07-06 09:25:02',NULL),(134200,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:26:00','2024-07-06 09:26:02',NULL),(134201,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:27:00','2024-07-06 09:27:02',NULL),(134202,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:28:00','2024-07-06 09:28:02',NULL),(134203,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:29:00','2024-07-06 09:29:02',NULL),(134204,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:30:00','2024-07-06 09:30:02',NULL),(134205,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:31:00','2024-07-06 09:31:02',NULL),(134206,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:32:00','2024-07-06 09:32:02',NULL),(134207,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:33:00','2024-07-06 09:33:02',NULL),(134208,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:34:00','2024-07-06 09:34:01',NULL),(134209,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:35:00','2024-07-06 09:35:02',NULL),(134210,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:36:00','2024-07-06 09:36:02',NULL),(134211,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:37:00','2024-07-06 09:37:02',NULL),(134212,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:19:02','2024-07-06 09:38:00','2024-07-06 09:38:02',NULL),(134484,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:39:00','2024-07-06 09:39:02',NULL),(134485,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:40:00','2024-07-06 09:40:02',NULL),(134486,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:41:00','2024-07-06 09:41:02',NULL),(134487,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:42:00','2024-07-06 09:42:02',NULL),(134488,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:43:00','2024-07-06 09:43:02',NULL),(134489,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:44:00','2024-07-06 09:44:02',NULL),(134490,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:45:00','2024-07-06 09:45:01',NULL),(134491,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:46:00','2024-07-06 09:46:02',NULL),(134492,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:47:00','2024-07-06 09:47:02',NULL),(134493,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:48:00','2024-07-06 09:48:02',NULL),(134494,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:49:00','2024-07-06 09:49:02',NULL),(134495,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:50:00','2024-07-06 09:50:01',NULL),(134496,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:51:00','2024-07-06 09:51:02',NULL),(134497,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:52:00','2024-07-06 09:52:02',NULL),(134498,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:53:00','2024-07-06 09:53:02',NULL),(134499,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:35:02','2024-07-06 09:54:00','2024-07-06 09:54:02',NULL),(134591,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134592,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134593,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134594,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134595,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134596,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134597,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134598,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134599,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134600,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134609,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134610,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134611,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134612,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134613,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134614,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134615,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134616,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134617,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134618,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134625,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134626,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134627,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134628,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134629,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134630,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134631,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134632,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134633,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134634,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134641,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134642,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134643,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134644,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134645,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134646,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134647,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134648,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134649,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134650,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134657,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134658,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134659,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134660,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134661,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134662,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134663,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134664,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134665,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134666,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134673,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134674,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134675,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134676,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134677,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134678,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134679,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134680,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134681,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134682,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134689,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134690,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134691,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134692,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134693,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134694,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134695,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134696,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134697,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134698,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134705,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134706,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134707,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134708,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134709,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134710,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134711,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134712,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134713,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134714,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134721,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:01:00','2024-07-06 09:51:02','2024-07-06 10:01:00',NULL,NULL),(134722,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134723,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:03:00','2024-07-06 09:51:02','2024-07-06 10:03:00',NULL,NULL),(134724,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134725,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134726,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134727,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:07:00','2024-07-06 09:51:02','2024-07-06 10:07:00',NULL,NULL),(134728,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134729,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:09:00','2024-07-06 09:51:02','2024-07-06 10:09:00',NULL,NULL),(134730,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134754,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 10:02:00','2024-07-06 09:51:02','2024-07-06 10:02:00',NULL,NULL),(134755,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 10:04:00','2024-07-06 09:51:02','2024-07-06 10:04:00',NULL,NULL),(134756,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 10:06:00','2024-07-06 09:51:02','2024-07-06 10:06:00',NULL,NULL),(134757,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 10:08:00','2024-07-06 09:51:02','2024-07-06 10:08:00',NULL,NULL),(134758,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134761,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 10:05:00','2024-07-06 09:51:02','2024-07-06 10:05:00',NULL,NULL),(134762,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 10:10:00','2024-07-06 09:51:02','2024-07-06 10:10:00',NULL,NULL),(134781,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 09:51:02','2024-07-06 10:01:00','2024-07-06 10:01:14',NULL),(134782,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 09:55:00','2024-07-06 09:55:02',NULL),(134783,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 09:56:00','2024-07-06 09:56:02',NULL),(134784,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 09:57:00','2024-07-06 09:57:02',NULL),(134785,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 09:58:00','2024-07-06 09:58:02',NULL),(134786,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 09:59:00','2024-07-06 09:59:02',NULL),(134787,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:00:00','2024-07-06 10:00:02',NULL),(134788,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:01:00','2024-07-06 10:01:02',NULL),(134789,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:02:00','2024-07-06 10:02:02',NULL),(134790,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:03:00','2024-07-06 10:03:02',NULL),(134791,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:04:00','2024-07-06 10:04:02',NULL),(134792,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:05:00','2024-07-06 10:05:02',NULL),(134793,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:06:00','2024-07-06 10:06:02',NULL),(134794,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:07:00','2024-07-06 10:07:02',NULL),(134795,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:08:00','2024-07-06 10:08:02',NULL),(134796,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:09:00','2024-07-06 10:09:02',NULL),(134797,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 09:51:02','2024-07-06 10:10:00','2024-07-06 10:10:02',NULL),(135105,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:11:00','2024-07-06 10:11:02',NULL),(135106,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:12:00','2024-07-06 10:12:02',NULL),(135107,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:13:00','2024-07-06 10:13:02',NULL),(135108,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:14:00','2024-07-06 10:14:02',NULL),(135109,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:15:00','2024-07-06 10:15:02',NULL),(135110,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:16:00','2024-07-06 10:16:02',NULL),(135111,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:17:00','2024-07-06 10:17:02',NULL),(135112,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:18:00','2024-07-06 10:18:02',NULL),(135113,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:19:00','2024-07-06 10:19:02',NULL),(135114,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:20:00','2024-07-06 10:20:02',NULL),(135115,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:21:00','2024-07-06 10:21:02',NULL),(135116,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:22:00','2024-07-06 10:22:02',NULL),(135117,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:23:00','2024-07-06 10:23:02',NULL),(135118,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:24:00','2024-07-06 10:24:02',NULL),(135119,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:06:02','2024-07-06 10:25:00','2024-07-06 10:25:02',NULL),(135379,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:26:00','2024-07-06 10:26:02',NULL),(135380,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:27:00','2024-07-06 10:27:02',NULL),(135381,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:28:00','2024-07-06 10:28:02',NULL),(135382,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:29:00','2024-07-06 10:29:01',NULL),(135383,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:30:00','2024-07-06 10:30:02',NULL),(135384,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:31:00','2024-07-06 10:31:02',NULL),(135385,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:32:00','2024-07-06 10:32:01',NULL),(135386,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:33:00','2024-07-06 10:33:02',NULL),(135387,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:34:00','2024-07-06 10:34:02',NULL),(135388,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:35:00','2024-07-06 10:35:01',NULL),(135389,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:36:00','2024-07-06 10:36:02',NULL),(135390,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:37:00','2024-07-06 10:37:01',NULL),(135391,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:38:00','2024-07-06 10:38:02',NULL),(135392,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:39:00','2024-07-06 10:39:02',NULL),(135393,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:21:02','2024-07-06 10:40:00','2024-07-06 10:40:02',NULL),(135648,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:41:00','2024-07-06 10:41:02',NULL),(135649,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:42:00','2024-07-06 10:42:02',NULL),(135650,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:43:00','2024-07-06 10:43:02',NULL),(135651,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:44:00','2024-07-06 10:44:02',NULL),(135652,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:45:00','2024-07-06 10:45:02',NULL),(135653,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:46:00','2024-07-06 10:46:02',NULL),(135654,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:47:00','2024-07-06 10:47:02',NULL),(135655,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:48:00','2024-07-06 10:48:02',NULL),(135656,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:49:00','2024-07-06 10:49:02',NULL),(135657,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:50:00','2024-07-06 10:50:02',NULL),(135658,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:51:00','2024-07-06 10:51:02',NULL),(135659,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:52:00','2024-07-06 10:52:02',NULL),(135660,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:53:00','2024-07-06 10:53:02',NULL),(135661,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:54:00','2024-07-06 10:54:02',NULL),(135662,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:36:02','2024-07-06 10:55:00','2024-07-06 10:55:02',NULL),(135750,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135751,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135752,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135753,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135754,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135755,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135756,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135757,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135758,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135759,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135767,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135768,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135769,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135770,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135771,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135772,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135773,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135774,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135775,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135776,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135782,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135783,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135784,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135785,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135786,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135787,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135788,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135789,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135790,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135791,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135797,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135798,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135799,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135800,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135801,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135802,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135803,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135804,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135805,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135806,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135812,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135813,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135814,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135815,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135816,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135817,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135818,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135819,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135820,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135821,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135827,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135828,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135829,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135830,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135831,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135832,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135833,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135834,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135835,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135836,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135842,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135843,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135844,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135845,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135846,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135847,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135848,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135849,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135850,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135851,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135857,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135858,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135859,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135860,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135861,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135862,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135863,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135864,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135865,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135866,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135872,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:01:00','2024-07-06 10:51:02','2024-07-06 11:01:00',NULL,NULL),(135873,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135874,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:03:00','2024-07-06 10:51:02','2024-07-06 11:03:00',NULL,NULL),(135875,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135876,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135877,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135878,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:07:00','2024-07-06 10:51:02','2024-07-06 11:07:00',NULL,NULL),(135879,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135880,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:09:00','2024-07-06 10:51:02','2024-07-06 11:09:00',NULL,NULL),(135881,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135904,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 11:02:00','2024-07-06 10:51:02','2024-07-06 11:02:00',NULL,NULL),(135905,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 11:04:00','2024-07-06 10:51:02','2024-07-06 11:04:00',NULL,NULL),(135906,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 11:06:00','2024-07-06 10:51:02','2024-07-06 11:06:00',NULL,NULL),(135907,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 11:08:00','2024-07-06 10:51:02','2024-07-06 11:08:00',NULL,NULL),(135908,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135910,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 11:05:00','2024-07-06 10:51:02','2024-07-06 11:05:00',NULL,NULL),(135911,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 11:10:00','2024-07-06 10:51:02','2024-07-06 11:10:00',NULL,NULL),(135929,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 10:51:02','2024-07-06 11:01:00','2024-07-06 11:01:14',NULL),(135930,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 10:56:00','2024-07-06 10:56:02',NULL),(135931,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 10:57:00','2024-07-06 10:57:01',NULL),(135932,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 10:58:00','2024-07-06 10:58:02',NULL),(135933,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 10:59:00','2024-07-06 10:59:02',NULL),(135934,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:00:00','2024-07-06 11:00:02',NULL),(135935,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:01:00','2024-07-06 11:01:02',NULL),(135936,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:02:00','2024-07-06 11:02:02',NULL),(135937,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:03:00','2024-07-06 11:03:02',NULL),(135938,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:04:00','2024-07-06 11:04:02',NULL),(135939,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:05:00','2024-07-06 11:05:02',NULL),(135940,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:06:00','2024-07-06 11:06:03',NULL),(135941,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:07:00','2024-07-06 11:07:02',NULL),(135942,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:08:00','2024-07-06 11:08:02',NULL),(135943,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:09:00','2024-07-06 11:09:02',NULL),(135944,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 10:51:02','2024-07-06 11:10:00','2024-07-06 11:10:02',NULL),(136251,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:11:00','2024-07-06 11:11:02',NULL),(136252,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:12:00','2024-07-06 11:12:02',NULL),(136253,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:13:00','2024-07-06 11:13:02',NULL),(136254,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:14:00','2024-07-06 11:14:02',NULL),(136255,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:15:00','2024-07-06 11:15:02',NULL),(136256,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:16:00','2024-07-06 11:16:02',NULL),(136257,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:17:00','2024-07-06 11:17:02',NULL),(136258,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:18:00','2024-07-06 11:18:02',NULL),(136259,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:19:00','2024-07-06 11:19:02',NULL),(136260,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:20:00','2024-07-06 11:20:02',NULL),(136261,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:21:00','2024-07-06 11:21:02',NULL),(136262,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:22:00','2024-07-06 11:22:02',NULL),(136263,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:23:00','2024-07-06 11:23:02',NULL),(136264,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:24:00','2024-07-06 11:24:02',NULL),(136265,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:06:03','2024-07-06 11:25:00','2024-07-06 11:25:02',NULL),(136526,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:26:00','2024-07-06 11:26:02',NULL),(136527,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:27:00','2024-07-06 11:27:02',NULL),(136528,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:28:00','2024-07-06 11:28:02',NULL),(136529,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:29:00','2024-07-06 11:29:02',NULL),(136530,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:30:00','2024-07-06 11:30:02',NULL),(136531,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:31:00','2024-07-06 11:31:02',NULL),(136532,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:32:00','2024-07-06 11:32:02',NULL),(136533,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:33:00','2024-07-06 11:33:02',NULL),(136534,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:34:00','2024-07-06 11:34:02',NULL),(136535,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:35:00','2024-07-06 11:35:02',NULL),(136536,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:36:00','2024-07-06 11:36:01',NULL),(136537,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:37:00','2024-07-06 11:37:02',NULL),(136538,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:38:00','2024-07-06 11:38:02',NULL),(136539,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:39:00','2024-07-06 11:39:02',NULL),(136540,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:21:02','2024-07-06 11:40:00','2024-07-06 11:40:02',NULL),(136810,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:41:00','2024-07-06 11:41:01',NULL),(136811,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:42:00','2024-07-06 11:42:02',NULL),(136812,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:43:00','2024-07-06 11:43:02',NULL),(136813,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:44:00','2024-07-06 11:44:02',NULL),(136814,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:45:00','2024-07-06 11:45:02',NULL),(136815,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:46:00','2024-07-06 11:46:02',NULL),(136816,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:47:00','2024-07-06 11:47:02',NULL),(136817,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:48:00','2024-07-06 11:48:02',NULL),(136818,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:49:00','2024-07-06 11:49:02',NULL),(136819,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:50:00','2024-07-06 11:50:02',NULL),(136820,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:51:00','2024-07-06 11:51:02',NULL),(136821,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:52:00','2024-07-06 11:52:01',NULL),(136822,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:53:00','2024-07-06 11:53:02',NULL),(136823,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:54:00','2024-07-06 11:54:02',NULL),(136824,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:55:00','2024-07-06 11:55:02',NULL),(136825,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:37:02','2024-07-06 11:56:00','2024-07-06 11:56:02',NULL),(136914,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(136915,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(136916,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(136917,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(136918,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(136919,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(136920,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(136921,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(136922,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(136923,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(136924,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(136925,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(136932,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(136933,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(136934,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(136935,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(136936,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(136937,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(136938,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(136939,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(136940,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(136941,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(136942,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(136943,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(136948,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(136949,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(136950,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(136951,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(136952,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(136953,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(136954,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(136955,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(136956,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(136957,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(136958,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(136959,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(136964,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(136965,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(136966,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(136967,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(136968,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(136969,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(136970,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(136971,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(136972,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(136973,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(136974,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(136975,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(136980,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(136981,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(136982,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(136983,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(136984,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(136985,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(136986,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(136987,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(136988,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(136989,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(136990,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(136991,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(136996,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(136997,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(136998,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(136999,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(137000,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(137001,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(137002,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(137003,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(137004,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(137005,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(137006,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(137007,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(137012,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(137013,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(137014,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(137015,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(137016,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(137017,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(137018,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(137019,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(137020,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(137021,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(137022,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(137023,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(137028,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(137029,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(137030,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(137031,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(137032,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(137033,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(137034,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(137035,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(137036,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(137037,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(137038,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(137039,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(137044,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:01:00','2024-07-06 11:53:02','2024-07-06 12:01:00',NULL,NULL),(137045,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(137046,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:03:00','2024-07-06 11:53:02','2024-07-06 12:03:00',NULL,NULL),(137047,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(137048,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(137049,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(137050,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:07:00','2024-07-06 11:53:02','2024-07-06 12:07:00',NULL,NULL),(137051,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(137052,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:09:00','2024-07-06 11:53:02','2024-07-06 12:09:00',NULL,NULL),(137053,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(137054,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:11:00','2024-07-06 11:53:02','2024-07-06 12:11:00',NULL,NULL),(137055,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(137078,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 12:02:00','2024-07-06 11:53:02','2024-07-06 12:02:00',NULL,NULL),(137079,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 12:04:00','2024-07-06 11:53:02','2024-07-06 12:04:00',NULL,NULL),(137080,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 12:06:00','2024-07-06 11:53:02','2024-07-06 12:06:00',NULL,NULL),(137081,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 12:08:00','2024-07-06 11:53:02','2024-07-06 12:08:00',NULL,NULL),(137082,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(137083,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 12:12:00','2024-07-06 11:53:02','2024-07-06 12:12:00',NULL,NULL),(137085,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 12:05:00','2024-07-06 11:53:02','2024-07-06 12:05:00',NULL,NULL),(137086,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 12:10:00','2024-07-06 11:53:02','2024-07-06 12:10:00',NULL,NULL),(137105,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 11:53:02','2024-07-06 12:01:00','2024-07-06 12:01:14',NULL),(137106,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 11:57:00','2024-07-06 11:57:02',NULL),(137107,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 11:58:00','2024-07-06 11:58:02',NULL),(137108,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 11:59:00','2024-07-06 11:59:02',NULL),(137109,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:00:00','2024-07-06 12:00:02',NULL),(137110,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:01:00','2024-07-06 12:01:02',NULL),(137111,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:02:00','2024-07-06 12:02:02',NULL),(137112,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:03:00','2024-07-06 12:03:02',NULL),(137113,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:04:00','2024-07-06 12:04:02',NULL),(137114,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:05:00','2024-07-06 12:05:02',NULL),(137115,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:06:00','2024-07-06 12:06:02',NULL),(137116,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:07:00','2024-07-06 12:07:02',NULL),(137117,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:08:00','2024-07-06 12:08:02',NULL),(137118,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:09:00','2024-07-06 12:09:02',NULL),(137119,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:10:00','2024-07-06 12:10:02',NULL),(137120,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:11:00','2024-07-06 12:11:02',NULL),(137121,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 11:53:02','2024-07-06 12:12:00','2024-07-06 12:12:02',NULL),(137429,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:13:00','2024-07-06 12:13:02',NULL),(137430,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:14:00','2024-07-06 12:14:02',NULL),(137431,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:15:00','2024-07-06 12:15:02',NULL),(137432,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:16:00','2024-07-06 12:16:02',NULL),(137433,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:17:00','2024-07-06 12:17:02',NULL),(137434,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:18:00','2024-07-06 12:18:02',NULL),(137435,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:19:00','2024-07-06 12:19:02',NULL),(137436,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:20:00','2024-07-06 12:20:02',NULL),(137437,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:21:00','2024-07-06 12:21:02',NULL),(137438,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:22:00','2024-07-06 12:22:02',NULL),(137439,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:23:00','2024-07-06 12:23:03',NULL),(137440,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:24:00','2024-07-06 12:24:02',NULL),(137441,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:25:00','2024-07-06 12:25:02',NULL),(137442,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:26:00','2024-07-06 12:26:02',NULL),(137443,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:08:02','2024-07-06 12:27:00','2024-07-06 12:27:02',NULL),(137703,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:28:00','2024-07-06 12:28:02',NULL),(137704,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:29:00','2024-07-06 12:29:02',NULL),(137705,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:30:00','2024-07-06 12:30:02',NULL),(137706,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:31:00','2024-07-06 12:31:02',NULL),(137707,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:32:00','2024-07-06 12:32:02',NULL),(137708,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:33:00','2024-07-06 12:33:02',NULL),(137709,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:34:00','2024-07-06 12:34:02',NULL),(137710,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:35:00','2024-07-06 12:35:02',NULL),(137711,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:36:00','2024-07-06 12:36:02',NULL),(137712,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:37:00','2024-07-06 12:37:02',NULL),(137713,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:38:00','2024-07-06 12:38:03',NULL),(137714,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:39:00','2024-07-06 12:39:02',NULL),(137715,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:40:00','2024-07-06 12:40:02',NULL),(137716,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:41:00','2024-07-06 12:41:02',NULL),(137717,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:23:03','2024-07-06 12:42:00','2024-07-06 12:42:02',NULL),(137973,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:43:00','2024-07-06 12:43:02',NULL),(137974,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:44:00','2024-07-06 12:44:02',NULL),(137975,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:45:00','2024-07-06 12:45:02',NULL),(137976,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:46:00','2024-07-06 12:46:02',NULL),(137977,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:47:00','2024-07-06 12:47:02',NULL),(137978,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:48:00','2024-07-06 12:48:02',NULL),(137979,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:49:00','2024-07-06 12:49:02',NULL),(137980,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:50:00','2024-07-06 12:50:02',NULL),(137981,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:51:00','2024-07-06 12:51:02',NULL),(137982,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:52:00','2024-07-06 12:52:01',NULL),(137983,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:53:00','2024-07-06 12:53:02',NULL),(137984,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:54:00','2024-07-06 12:54:02',NULL),(137985,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:55:00','2024-07-06 12:55:02',NULL),(137986,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:56:00','2024-07-06 12:56:02',NULL),(137987,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:38:03','2024-07-06 12:57:00','2024-07-06 12:57:02',NULL),(138069,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138070,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138071,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138072,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138073,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138074,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138075,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138076,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138077,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138078,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138079,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138080,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138086,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138087,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138088,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138089,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138090,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138091,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138092,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138093,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138094,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138095,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138096,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138097,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138101,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138102,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138103,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138104,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138105,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138106,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138107,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138108,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138109,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138110,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138111,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138112,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138116,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138117,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138118,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138119,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138120,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138121,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138122,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138123,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138124,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138125,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138126,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138127,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138131,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138132,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138133,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138134,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138135,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138136,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138137,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138138,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138139,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138140,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138141,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138142,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138146,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138147,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138148,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138149,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138150,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138151,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138152,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138153,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138154,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138155,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138156,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138157,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138161,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138162,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138163,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138164,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138165,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138166,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138167,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138168,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138169,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138170,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138171,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138172,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138176,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138177,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138178,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138179,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138180,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138181,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138182,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138183,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138184,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138185,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138186,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138187,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138191,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:01:00','2024-07-06 12:53:02','2024-07-06 13:01:00',NULL,NULL),(138192,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138193,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:03:00','2024-07-06 12:53:02','2024-07-06 13:03:00',NULL,NULL),(138194,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138195,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138196,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138197,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:07:00','2024-07-06 12:53:02','2024-07-06 13:07:00',NULL,NULL),(138198,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138199,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:09:00','2024-07-06 12:53:02','2024-07-06 13:09:00',NULL,NULL),(138200,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138201,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:11:00','2024-07-06 12:53:02','2024-07-06 13:11:00',NULL,NULL),(138202,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138224,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 13:02:00','2024-07-06 12:53:02','2024-07-06 13:02:00',NULL,NULL),(138225,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 13:04:00','2024-07-06 12:53:02','2024-07-06 13:04:00',NULL,NULL),(138226,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 13:06:00','2024-07-06 12:53:02','2024-07-06 13:06:00',NULL,NULL),(138227,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 13:08:00','2024-07-06 12:53:02','2024-07-06 13:08:00',NULL,NULL),(138228,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138229,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 13:12:00','2024-07-06 12:53:02','2024-07-06 13:12:00',NULL,NULL),(138231,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 13:05:00','2024-07-06 12:53:02','2024-07-06 13:05:00',NULL,NULL),(138232,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 13:10:00','2024-07-06 12:53:02','2024-07-06 13:10:00',NULL,NULL),(138250,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 12:53:02','2024-07-06 13:01:00','2024-07-06 13:01:14',NULL),(138251,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 12:58:00','2024-07-06 12:58:02',NULL),(138252,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 12:59:00','2024-07-06 12:59:02',NULL),(138253,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:00:00','2024-07-06 13:00:02',NULL),(138254,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:01:00','2024-07-06 13:01:02',NULL),(138255,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:02:00','2024-07-06 13:02:02',NULL),(138256,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:03:00','2024-07-06 13:03:02',NULL),(138257,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:04:00','2024-07-06 13:04:02',NULL),(138258,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:05:00','2024-07-06 13:05:02',NULL),(138259,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:06:00','2024-07-06 13:06:02',NULL),(138260,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:07:00','2024-07-06 13:07:02',NULL),(138261,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:08:00','2024-07-06 13:08:02',NULL),(138262,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:09:00','2024-07-06 13:09:02',NULL),(138263,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:10:00','2024-07-06 13:10:02',NULL),(138264,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:11:00','2024-07-06 13:11:02',NULL),(138265,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 12:53:02','2024-07-06 13:12:00','2024-07-06 13:12:02',NULL),(138573,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:13:00','2024-07-06 13:13:02',NULL),(138574,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:14:00','2024-07-06 13:14:02',NULL),(138575,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:15:00','2024-07-06 13:15:02',NULL),(138576,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:16:00','2024-07-06 13:16:02',NULL),(138577,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:17:00','2024-07-06 13:17:02',NULL),(138578,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:18:00','2024-07-06 13:18:02',NULL),(138579,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:19:00','2024-07-06 13:19:02',NULL),(138580,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:20:00','2024-07-06 13:20:02',NULL),(138581,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:21:00','2024-07-06 13:21:02',NULL),(138582,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:22:00','2024-07-06 13:22:02',NULL),(138583,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:23:00','2024-07-06 13:23:03',NULL),(138584,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:24:00','2024-07-06 13:24:02',NULL),(138585,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:25:00','2024-07-06 13:25:02',NULL),(138586,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:26:00','2024-07-06 13:26:02',NULL),(138587,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:08:02','2024-07-06 13:27:00','2024-07-06 13:27:02',NULL),(138847,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:28:00','2024-07-06 13:28:02',NULL),(138848,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:29:00','2024-07-06 13:29:02',NULL),(138849,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:30:00','2024-07-06 13:30:02',NULL),(138850,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:31:00','2024-07-06 13:31:02',NULL),(138851,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:32:00','2024-07-06 13:32:02',NULL),(138852,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:33:00','2024-07-06 13:33:02',NULL),(138853,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:34:00','2024-07-06 13:34:02',NULL),(138854,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:35:00','2024-07-06 13:35:02',NULL),(138855,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:36:00','2024-07-06 13:36:02',NULL),(138856,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:37:00','2024-07-06 13:37:02',NULL),(138857,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:38:00','2024-07-06 13:38:02',NULL),(138858,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:39:00','2024-07-06 13:39:02',NULL),(138859,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:40:00','2024-07-06 13:40:02',NULL),(138860,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:41:00','2024-07-06 13:41:02',NULL),(138861,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:23:03','2024-07-06 13:42:00','2024-07-06 13:42:02',NULL),(139117,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:43:00','2024-07-06 13:43:02',NULL),(139118,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:44:00','2024-07-06 13:44:02',NULL),(139119,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:45:00','2024-07-06 13:45:02',NULL),(139120,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:46:00','2024-07-06 13:46:02',NULL),(139121,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:47:00','2024-07-06 13:47:02',NULL),(139122,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:48:00','2024-07-06 13:48:02',NULL),(139123,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:49:00','2024-07-06 13:49:02',NULL),(139124,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:50:00','2024-07-06 13:50:02',NULL),(139125,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:51:00','2024-07-06 13:51:02',NULL),(139126,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:52:00','2024-07-06 13:52:02',NULL),(139127,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:53:00','2024-07-06 13:53:02',NULL),(139128,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:54:00','2024-07-06 13:54:02',NULL),(139129,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:55:00','2024-07-06 13:55:02',NULL),(139130,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:56:00','2024-07-06 13:56:02',NULL),(139131,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:38:02','2024-07-06 13:57:00','2024-07-06 13:57:02',NULL),(139214,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139215,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139216,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139217,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139218,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139219,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139220,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139221,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139222,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139223,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139224,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139225,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139231,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139232,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139233,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139234,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139235,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139236,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139237,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139238,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139239,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139240,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139241,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139242,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139246,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139247,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139248,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139249,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139250,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139251,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139252,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139253,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139254,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139255,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139256,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139257,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139261,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139262,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139263,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139264,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139265,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139266,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139267,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139268,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139269,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139270,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139271,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139272,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139276,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139277,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139278,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139279,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139280,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139281,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139282,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139283,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139284,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139285,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139286,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139287,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139291,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139292,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139293,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139294,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139295,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139296,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139297,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139298,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139299,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139300,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139301,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139302,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139306,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139307,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139308,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139309,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139310,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139311,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139312,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139313,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139314,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139315,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139316,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139317,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139321,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139322,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139323,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139324,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139325,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139326,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139327,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139328,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139329,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139330,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139331,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139332,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139336,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:01:00','2024-07-06 13:53:02','2024-07-06 14:01:00',NULL,NULL),(139337,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139338,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:03:00','2024-07-06 13:53:02','2024-07-06 14:03:00',NULL,NULL),(139339,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139340,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139341,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139342,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:07:00','2024-07-06 13:53:02','2024-07-06 14:07:00',NULL,NULL),(139343,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139344,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:09:00','2024-07-06 13:53:02','2024-07-06 14:09:00',NULL,NULL),(139345,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139346,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:11:00','2024-07-06 13:53:02','2024-07-06 14:11:00',NULL,NULL),(139347,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139369,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 14:02:00','2024-07-06 13:53:02','2024-07-06 14:02:00',NULL,NULL),(139370,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 14:04:00','2024-07-06 13:53:02','2024-07-06 14:04:00',NULL,NULL),(139371,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 14:06:00','2024-07-06 13:53:02','2024-07-06 14:06:00',NULL,NULL),(139372,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 14:08:00','2024-07-06 13:53:02','2024-07-06 14:08:00',NULL,NULL),(139373,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139374,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 14:12:00','2024-07-06 13:53:02','2024-07-06 14:12:00',NULL,NULL),(139376,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 14:05:00','2024-07-06 13:53:02','2024-07-06 14:05:00',NULL,NULL),(139377,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 14:10:00','2024-07-06 13:53:02','2024-07-06 14:10:00',NULL,NULL),(139395,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 13:53:02','2024-07-06 14:01:00','2024-07-06 14:01:14',NULL),(139396,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 13:58:00','2024-07-06 13:58:02',NULL),(139397,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 13:59:00','2024-07-06 13:59:02',NULL),(139398,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:00:00','2024-07-06 14:00:02',NULL),(139399,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:01:00','2024-07-06 14:01:02',NULL),(139400,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:02:00','2024-07-06 14:02:02',NULL),(139401,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:03:00','2024-07-06 14:03:02',NULL),(139402,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:04:00','2024-07-06 14:04:02',NULL),(139403,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:05:00','2024-07-06 14:05:02',NULL),(139404,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:06:00','2024-07-06 14:06:02',NULL),(139405,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:07:00','2024-07-06 14:07:02',NULL),(139406,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:08:00','2024-07-06 14:08:03',NULL),(139407,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:09:00','2024-07-06 14:09:02',NULL),(139408,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:10:00','2024-07-06 14:10:02',NULL),(139409,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:11:00','2024-07-06 14:11:02',NULL),(139410,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 13:53:02','2024-07-06 14:12:00','2024-07-06 14:12:02',NULL),(139719,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:13:00','2024-07-06 14:13:02',NULL),(139720,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:14:00','2024-07-06 14:14:02',NULL),(139721,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:15:00','2024-07-06 14:15:02',NULL),(139722,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:16:00','2024-07-06 14:16:02',NULL),(139723,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:17:00','2024-07-06 14:17:02',NULL),(139724,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:18:00','2024-07-06 14:18:02',NULL),(139725,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:19:00','2024-07-06 14:19:02',NULL),(139726,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:20:00','2024-07-06 14:20:02',NULL),(139727,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:21:00','2024-07-06 14:21:02',NULL),(139728,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:22:00','2024-07-06 14:22:02',NULL),(139729,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:23:00','2024-07-06 14:23:03',NULL),(139730,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:24:00','2024-07-06 14:24:02',NULL),(139731,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:25:00','2024-07-06 14:25:02',NULL),(139732,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:26:00','2024-07-06 14:26:02',NULL),(139733,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:08:03','2024-07-06 14:27:00','2024-07-06 14:27:02',NULL),(139994,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:28:00','2024-07-06 14:28:02',NULL),(139995,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:29:00','2024-07-06 14:29:02',NULL),(139996,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:30:00','2024-07-06 14:30:02',NULL),(139997,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:31:00','2024-07-06 14:31:02',NULL),(139998,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:32:00','2024-07-06 14:32:02',NULL),(139999,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:33:00','2024-07-06 14:33:02',NULL),(140000,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:34:00','2024-07-06 14:34:02',NULL),(140001,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:35:00','2024-07-06 14:35:02',NULL),(140002,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:36:00','2024-07-06 14:36:02',NULL),(140003,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:37:00','2024-07-06 14:37:02',NULL),(140004,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:38:00','2024-07-06 14:38:02',NULL),(140005,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:39:00','2024-07-06 14:39:02',NULL),(140006,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:40:00','2024-07-06 14:40:02',NULL),(140007,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:41:00','2024-07-06 14:41:02',NULL),(140008,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:23:03','2024-07-06 14:42:00','2024-07-06 14:42:02',NULL),(140247,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:43:00','2024-07-06 14:43:02',NULL),(140248,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:44:00','2024-07-06 14:44:02',NULL),(140249,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:45:00','2024-07-06 14:45:02',NULL),(140250,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:46:00','2024-07-06 14:46:02',NULL),(140251,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:47:00','2024-07-06 14:47:02',NULL),(140252,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:48:00','2024-07-06 14:48:02',NULL),(140253,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:49:00','2024-07-06 14:49:02',NULL),(140254,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:50:00','2024-07-06 14:50:02',NULL),(140255,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:51:00','2024-07-06 14:51:02',NULL),(140256,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:52:00','2024-07-06 14:52:02',NULL),(140257,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:53:00','2024-07-06 14:53:02',NULL),(140258,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:54:00','2024-07-06 14:54:02',NULL),(140259,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:55:00','2024-07-06 14:55:02',NULL),(140260,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:56:00','2024-07-06 14:56:02',NULL),(140261,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:38:02','2024-07-06 14:57:00','2024-07-06 14:57:02',NULL),(140348,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140349,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140350,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140351,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140352,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140353,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140354,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140355,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140356,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140357,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140358,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140359,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140365,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140366,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140367,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140368,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140369,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140370,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140371,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140372,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140373,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140374,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140375,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140376,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140380,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140381,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140382,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140383,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140384,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140385,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140386,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140387,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140388,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140389,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140390,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140391,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140395,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140396,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140397,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140398,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140399,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140400,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140401,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140402,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140403,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140404,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140405,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140406,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140410,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140411,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140412,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140413,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140414,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140415,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140416,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140417,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140418,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140419,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140420,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140421,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140425,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140426,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140427,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140428,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140429,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140430,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140431,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140432,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140433,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140434,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140435,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140436,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140440,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140441,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140442,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140443,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140444,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140445,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140446,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140447,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140448,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140449,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140450,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140451,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140455,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140456,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140457,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140458,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140459,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140460,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140461,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140462,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140463,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140464,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140465,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140466,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140470,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:01:00','2024-07-06 14:53:02','2024-07-06 15:01:00',NULL,NULL),(140471,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140472,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:03:00','2024-07-06 14:53:02','2024-07-06 15:03:00',NULL,NULL),(140473,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140474,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140475,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140476,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:07:00','2024-07-06 14:53:02','2024-07-06 15:07:00',NULL,NULL),(140477,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140478,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:09:00','2024-07-06 14:53:02','2024-07-06 15:09:00',NULL,NULL),(140479,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140480,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:11:00','2024-07-06 14:53:02','2024-07-06 15:11:00',NULL,NULL),(140481,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140503,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 15:02:00','2024-07-06 14:53:02','2024-07-06 15:02:00',NULL,NULL),(140504,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 15:04:00','2024-07-06 14:53:02','2024-07-06 15:04:00',NULL,NULL),(140505,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 15:06:00','2024-07-06 14:53:02','2024-07-06 15:06:00',NULL,NULL),(140506,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 15:08:00','2024-07-06 14:53:02','2024-07-06 15:08:00',NULL,NULL),(140507,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140508,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 15:12:00','2024-07-06 14:53:02','2024-07-06 15:12:00',NULL,NULL),(140510,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 15:05:00','2024-07-06 14:53:02','2024-07-06 15:05:00',NULL,NULL),(140511,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 15:10:00','2024-07-06 14:53:02','2024-07-06 15:10:00',NULL,NULL),(140529,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 14:53:02','2024-07-06 15:01:00','2024-07-06 15:01:14',NULL),(140530,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 14:58:00','2024-07-06 14:58:02',NULL),(140531,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 14:59:00','2024-07-06 14:59:02',NULL),(140532,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:00:00','2024-07-06 15:00:02',NULL),(140533,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:01:00','2024-07-06 15:01:02',NULL),(140534,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:02:00','2024-07-06 15:02:02',NULL),(140535,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:03:00','2024-07-06 15:03:02',NULL),(140536,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:04:00','2024-07-06 15:04:02',NULL),(140537,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:05:00','2024-07-06 15:05:02',NULL),(140538,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:06:00','2024-07-06 15:06:02',NULL),(140539,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:07:00','2024-07-06 15:07:02',NULL),(140540,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:08:00','2024-07-06 15:08:02',NULL),(140541,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:09:00','2024-07-06 15:09:02',NULL),(140542,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:10:00','2024-07-06 15:10:02',NULL),(140543,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:11:00','2024-07-06 15:11:01',NULL),(140544,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 14:53:02','2024-07-06 15:12:00','2024-07-06 15:12:02',NULL),(140850,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:13:00','2024-07-06 15:13:02',NULL),(140851,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:14:00','2024-07-06 15:14:01',NULL),(140852,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:15:00','2024-07-06 15:15:02',NULL),(140853,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:16:00','2024-07-06 15:16:02',NULL),(140854,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:17:00','2024-07-06 15:17:01',NULL),(140855,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:18:00','2024-07-06 15:18:02',NULL),(140856,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:19:00','2024-07-06 15:19:02',NULL),(140857,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:20:00','2024-07-06 15:20:02',NULL),(140858,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:21:00','2024-07-06 15:21:02',NULL),(140859,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:22:00','2024-07-06 15:22:02',NULL),(140860,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:23:00','2024-07-06 15:23:02',NULL),(140861,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:24:00','2024-07-06 15:24:02',NULL),(140862,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:25:00','2024-07-06 15:25:02',NULL),(140863,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:26:00','2024-07-06 15:26:02',NULL),(140864,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:08:02','2024-07-06 15:27:00','2024-07-06 15:27:02',NULL),(141137,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:28:00','2024-07-06 15:28:02',NULL),(141138,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:29:00','2024-07-06 15:29:02',NULL),(141139,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:30:00','2024-07-06 15:30:02',NULL),(141140,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:31:00','2024-07-06 15:31:02',NULL),(141141,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:32:00','2024-07-06 15:32:02',NULL),(141142,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:33:00','2024-07-06 15:33:02',NULL),(141143,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:34:00','2024-07-06 15:34:02',NULL),(141144,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:35:00','2024-07-06 15:35:02',NULL),(141145,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:36:00','2024-07-06 15:36:02',NULL),(141146,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:37:00','2024-07-06 15:37:02',NULL),(141147,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:38:00','2024-07-06 15:38:01',NULL),(141148,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:39:00','2024-07-06 15:39:02',NULL),(141149,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:40:00','2024-07-06 15:40:02',NULL),(141150,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:41:00','2024-07-06 15:41:02',NULL),(141151,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:42:00','2024-07-06 15:42:02',NULL),(141152,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:24:02','2024-07-06 15:43:00','2024-07-06 15:43:02',NULL),(141410,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:44:00','2024-07-06 15:44:02',NULL),(141411,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:45:00','2024-07-06 15:45:02',NULL),(141412,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:46:00','2024-07-06 15:46:01',NULL),(141413,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:47:00','2024-07-06 15:47:02',NULL),(141414,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:48:00','2024-07-06 15:48:02',NULL),(141415,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:49:00','2024-07-06 15:49:02',NULL),(141416,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:50:00','2024-07-06 15:50:02',NULL),(141417,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:51:00','2024-07-06 15:51:02',NULL),(141418,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:52:00','2024-07-06 15:52:02',NULL),(141419,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:53:00','2024-07-06 15:53:02',NULL),(141420,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:54:00','2024-07-06 15:54:02',NULL),(141421,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:55:00','2024-07-06 15:55:02',NULL),(141422,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:56:00','2024-07-06 15:56:02',NULL),(141423,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:57:00','2024-07-06 15:57:02',NULL),(141424,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:39:02','2024-07-06 15:58:00','2024-07-06 15:58:02',NULL),(141509,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141510,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141511,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141512,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141513,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141514,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141515,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141516,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141517,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141518,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141519,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141520,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141521,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141526,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141527,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141528,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141529,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141530,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141531,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141532,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141533,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141534,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141535,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141536,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141537,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141538,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141541,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141542,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141543,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141544,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141545,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141546,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141547,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141548,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141549,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141550,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141551,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141552,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141553,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141556,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141557,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141558,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141559,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141560,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141561,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141562,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141563,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141564,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141565,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141566,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141567,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141568,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141571,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141572,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141573,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141574,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141575,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141576,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141577,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141578,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141579,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141580,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141581,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141582,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141583,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141586,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141587,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141588,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141589,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141590,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141591,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141592,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141593,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141594,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141595,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141596,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141597,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141598,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141601,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141602,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141603,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141604,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141605,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141606,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141607,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141608,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141609,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141610,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141611,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141612,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141613,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141616,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141617,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141618,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141619,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141620,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141621,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141622,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141623,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141624,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141625,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141626,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141627,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141628,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141631,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:01:00','2024-07-06 15:54:02','2024-07-06 16:01:00',NULL,NULL),(141632,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141633,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:03:00','2024-07-06 15:54:02','2024-07-06 16:03:00',NULL,NULL),(141634,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141635,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141636,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141637,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:07:00','2024-07-06 15:54:02','2024-07-06 16:07:00',NULL,NULL),(141638,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141639,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:09:00','2024-07-06 15:54:02','2024-07-06 16:09:00',NULL,NULL),(141640,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141641,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:11:00','2024-07-06 15:54:02','2024-07-06 16:11:00',NULL,NULL),(141642,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141643,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 16:13:00','2024-07-06 15:54:02','2024-07-06 16:13:00',NULL,NULL),(141664,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 16:02:00','2024-07-06 15:54:02','2024-07-06 16:02:00',NULL,NULL),(141665,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 16:04:00','2024-07-06 15:54:02','2024-07-06 16:04:00',NULL,NULL),(141666,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 16:06:00','2024-07-06 15:54:02','2024-07-06 16:06:00',NULL,NULL),(141667,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 16:08:00','2024-07-06 15:54:02','2024-07-06 16:08:00',NULL,NULL),(141668,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141669,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 16:12:00','2024-07-06 15:54:02','2024-07-06 16:12:00',NULL,NULL),(141671,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 16:05:00','2024-07-06 15:54:02','2024-07-06 16:05:00',NULL,NULL),(141672,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 16:10:00','2024-07-06 15:54:02','2024-07-06 16:10:00',NULL,NULL),(141690,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 15:54:02','2024-07-06 16:01:00','2024-07-06 16:01:14',NULL),(141691,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 15:59:00','2024-07-06 15:59:02',NULL),(141692,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:00:00','2024-07-06 16:00:02',NULL),(141693,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:01:00','2024-07-06 16:01:02',NULL),(141694,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:02:00','2024-07-06 16:02:02',NULL),(141695,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:03:00','2024-07-06 16:03:02',NULL),(141696,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:04:00','2024-07-06 16:04:02',NULL),(141697,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:05:00','2024-07-06 16:05:02',NULL),(141698,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:06:00','2024-07-06 16:06:02',NULL),(141699,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:07:00','2024-07-06 16:07:02',NULL),(141700,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:08:00','2024-07-06 16:08:02',NULL),(141701,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:09:00','2024-07-06 16:09:02',NULL),(141702,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:10:00','2024-07-06 16:10:02',NULL),(141703,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:11:00','2024-07-06 16:11:02',NULL),(141704,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:12:00','2024-07-06 16:12:02',NULL),(141705,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 15:54:02','2024-07-06 16:13:00','2024-07-06 16:13:02',NULL),(142011,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:14:00','2024-07-06 16:14:02',NULL),(142012,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:15:00','2024-07-06 16:15:02',NULL),(142013,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:16:00','2024-07-06 16:16:02',NULL),(142014,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:17:00','2024-07-06 16:17:02',NULL),(142015,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:18:00','2024-07-06 16:18:01',NULL),(142016,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:19:00','2024-07-06 16:19:02',NULL),(142017,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:20:00','2024-07-06 16:20:02',NULL),(142018,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:21:00','2024-07-06 16:21:02',NULL),(142019,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:22:00','2024-07-06 16:22:02',NULL),(142020,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:23:00','2024-07-06 16:23:02',NULL),(142021,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:24:00','2024-07-06 16:24:01',NULL),(142022,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:25:00','2024-07-06 16:25:02',NULL),(142023,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:26:00','2024-07-06 16:26:02',NULL),(142024,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:27:00','2024-07-06 16:27:02',NULL),(142025,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:09:02','2024-07-06 16:28:00','2024-07-06 16:28:02',NULL),(142298,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:29:00','2024-07-06 16:29:02',NULL),(142299,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:30:00','2024-07-06 16:30:02',NULL),(142300,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:31:00','2024-07-06 16:31:02',NULL),(142301,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:32:00','2024-07-06 16:32:02',NULL),(142302,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:33:00','2024-07-06 16:33:02',NULL),(142303,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:34:00','2024-07-06 16:34:02',NULL),(142304,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:35:00','2024-07-06 16:35:02',NULL),(142305,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:36:00','2024-07-06 16:36:02',NULL),(142306,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:37:00','2024-07-06 16:37:02',NULL),(142307,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:38:00','2024-07-06 16:38:02',NULL),(142308,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:39:00','2024-07-06 16:39:02',NULL),(142309,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:40:00','2024-07-06 16:40:03',NULL),(142310,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:41:00','2024-07-06 16:41:02',NULL),(142311,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:42:00','2024-07-06 16:42:02',NULL),(142312,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:43:00','2024-07-06 16:43:02',NULL),(142313,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:25:02','2024-07-06 16:44:00','2024-07-06 16:44:02',NULL),(142572,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:45:00','2024-07-06 16:45:02',NULL),(142573,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:46:00','2024-07-06 16:46:02',NULL),(142574,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:47:00','2024-07-06 16:47:02',NULL),(142575,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:48:00','2024-07-06 16:48:02',NULL),(142576,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:49:00','2024-07-06 16:49:02',NULL),(142577,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:50:00','2024-07-06 16:50:02',NULL),(142578,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:51:00','2024-07-06 16:51:01',NULL),(142579,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:52:00','2024-07-06 16:52:02',NULL),(142580,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:53:00','2024-07-06 16:53:02',NULL),(142581,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:54:00','2024-07-06 16:54:03',NULL),(142582,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:55:00','2024-07-06 16:55:02',NULL),(142583,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:56:00','2024-07-06 16:56:01',NULL),(142584,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:57:00','2024-07-06 16:57:02',NULL),(142585,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:58:00','2024-07-06 16:58:02',NULL),(142586,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:40:03','2024-07-06 16:59:00','2024-07-06 16:59:01',NULL),(142668,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142669,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142670,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142671,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142672,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142673,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142674,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142675,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142676,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142677,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142678,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142679,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142680,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142681,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142685,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142686,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142687,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142688,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142689,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142690,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142691,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142692,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142693,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142694,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142695,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142696,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142697,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142698,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142700,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142701,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142702,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142703,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142704,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142705,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142706,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142707,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142708,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142709,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142710,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142711,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142712,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142713,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142715,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142716,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142717,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142718,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142719,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142720,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142721,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142722,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142723,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142724,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142725,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142726,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142727,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142728,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142730,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142731,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142732,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142733,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142734,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142735,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142736,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142737,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142738,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142739,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142740,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142741,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142742,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142743,'sales_grid_order_creditmemo_async_insert','missed','Cron Job sales_grid_order_creditmemo_async_insert is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142745,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142746,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142747,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142748,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142749,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142750,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142751,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142752,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142753,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142754,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142755,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142756,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142757,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142758,'sales_send_order_emails','missed','Cron Job sales_send_order_emails is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142760,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142761,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142762,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142763,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142764,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142765,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142766,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142767,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142768,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142769,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142770,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142771,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142772,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142773,'sales_send_order_invoice_emails','missed','Cron Job sales_send_order_invoice_emails is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142775,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142776,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142777,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142778,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142779,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142780,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142781,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142782,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142783,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142784,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142785,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142786,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142787,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142788,'sales_send_order_shipment_emails','missed','Cron Job sales_send_order_shipment_emails is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142790,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:01:00','2024-07-06 16:55:02','2024-07-06 17:01:00',NULL,NULL),(142791,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142792,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:03:00','2024-07-06 16:55:02','2024-07-06 17:03:00',NULL,NULL),(142793,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142794,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142795,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142796,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:07:00','2024-07-06 16:55:02','2024-07-06 17:07:00',NULL,NULL),(142797,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142798,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:09:00','2024-07-06 16:55:02','2024-07-06 17:09:00',NULL,NULL),(142799,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142800,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:11:00','2024-07-06 16:55:02','2024-07-06 17:11:00',NULL,NULL),(142801,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142802,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:13:00','2024-07-06 16:55:02','2024-07-06 17:13:00',NULL,NULL),(142803,'sales_send_order_creditmemo_emails','missed','Cron Job sales_send_order_creditmemo_emails is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142824,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 17:02:00','2024-07-06 16:55:02','2024-07-06 17:02:00',NULL,NULL),(142825,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 17:04:00','2024-07-06 16:55:02','2024-07-06 17:04:00',NULL,NULL),(142826,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 17:06:00','2024-07-06 16:55:02','2024-07-06 17:06:00',NULL,NULL),(142827,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 17:08:00','2024-07-06 16:55:02','2024-07-06 17:08:00',NULL,NULL),(142828,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142829,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 17:12:00','2024-07-06 16:55:02','2024-07-06 17:12:00',NULL,NULL),(142830,'magento_newrelicreporting_cron','missed','Cron Job magento_newrelicreporting_cron is missed at 2024-07-06 17:14:00','2024-07-06 16:55:02','2024-07-06 17:14:00',NULL,NULL),(142832,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 17:05:00','2024-07-06 16:55:02','2024-07-06 17:05:00',NULL,NULL),(142833,'newsletter_send_all','missed','Cron Job newsletter_send_all is missed at 2024-07-06 17:10:00','2024-07-06 16:55:02','2024-07-06 17:10:00',NULL,NULL),(142851,'katalyst_shirt_cron','error','SQLSTATE[42S02]: Base table or view not found: 1146 Table \'ecom.generation_cmd\' doesn\'t exist, query was: SELECT `id`, `flag`, `cmd` FROM generation_cmd WHERE `flag`=0 ORDER BY id ASC','2024-07-06 16:55:02','2024-07-06 17:01:00','2024-07-06 17:01:15',NULL),(142852,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:00:00','2024-07-06 17:00:02',NULL),(142853,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:01:00','2024-07-06 17:01:02',NULL),(142854,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:02:00','2024-07-06 17:02:02',NULL),(142855,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:03:00','2024-07-06 17:03:02',NULL),(142856,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:04:00','2024-07-06 17:04:02',NULL),(142857,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:05:00','2024-07-06 17:05:02',NULL),(142858,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:06:00','2024-07-06 17:06:02',NULL),(142859,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:07:00','2024-07-06 17:07:02',NULL),(142860,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:08:00','2024-07-06 17:08:02',NULL),(142861,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:09:00','2024-07-06 17:09:02',NULL),(142862,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:10:00','2024-07-06 17:10:02',NULL),(142863,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:11:00','2024-07-06 17:11:01',NULL),(142864,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:12:00','2024-07-06 17:12:02',NULL),(142865,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:13:00','2024-07-06 17:13:02',NULL),(142866,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 16:55:02','2024-07-06 17:14:00','2024-07-06 17:14:02',NULL),(143170,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:15:00','2024-07-06 17:15:02',NULL),(143171,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:16:00','2024-07-06 17:16:02',NULL),(143172,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:17:00','2024-07-06 17:17:01',NULL),(143173,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:18:00','2024-07-06 17:18:02',NULL),(143174,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:19:00','2024-07-06 17:19:02',NULL),(143175,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:20:00','2024-07-06 17:20:01',NULL),(143176,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:21:00','2024-07-06 17:21:02',NULL),(143177,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:22:00','2024-07-06 17:22:02',NULL),(143178,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:23:00','2024-07-06 17:23:01',NULL),(143179,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:24:00','2024-07-06 17:24:02',NULL),(143180,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:25:00','2024-07-06 17:25:02',NULL),(143181,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:26:00','2024-07-06 17:26:02',NULL),(143182,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:27:00','2024-07-06 17:27:02',NULL),(143183,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:28:00','2024-07-06 17:28:02',NULL),(143184,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:10:02','2024-07-06 17:29:00','2024-07-06 17:29:02',NULL),(143446,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:30:00','2024-07-06 17:30:02',NULL),(143447,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:31:00','2024-07-06 17:31:02',NULL),(143448,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:32:00','2024-07-06 17:32:02',NULL),(143449,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:33:00','2024-07-06 17:33:02',NULL),(143450,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:34:00','2024-07-06 17:34:02',NULL),(143451,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:35:00','2024-07-06 17:35:02',NULL),(143452,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:36:00','2024-07-06 17:36:02',NULL),(143453,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:37:00','2024-07-06 17:37:02',NULL),(143454,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:38:00','2024-07-06 17:38:02',NULL),(143455,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:39:00','2024-07-06 17:39:02',NULL),(143456,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:40:00','2024-07-06 17:40:02',NULL),(143457,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:41:00','2024-07-06 17:41:02',NULL),(143458,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:42:00','2024-07-06 17:42:02',NULL),(143459,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:43:00','2024-07-06 17:43:02',NULL),(143460,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:25:02','2024-07-06 17:44:00','2024-07-06 17:44:02',NULL),(143716,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:45:00','2024-07-06 17:45:02',NULL),(143717,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:46:00','2024-07-06 17:46:02',NULL),(143718,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:47:00','2024-07-06 17:47:02',NULL),(143719,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:48:00','2024-07-06 17:48:02',NULL),(143720,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:49:00','2024-07-06 17:49:02',NULL),(143721,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:50:00','2024-07-06 17:50:02',NULL),(143722,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:51:00','2024-07-06 17:51:02',NULL),(143723,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:52:00','2024-07-06 17:52:02',NULL),(143724,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:53:00','2024-07-06 17:53:02',NULL),(143725,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:54:00','2024-07-06 17:54:02',NULL),(143726,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:55:00','2024-07-06 17:55:02',NULL),(143727,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:56:00','2024-07-06 17:56:02',NULL),(143728,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:57:00','2024-07-06 17:57:02',NULL),(143729,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:58:00','2024-07-06 17:58:02',NULL),(143730,'cron_for_fabric_generation','error','Warning: file_get_contents(): php_network_getaddresses: getaddrinfo for s3.eu-west-2.amazonaws.com failed: Temporary failure in name resolution in /var/www/html/ecom/app/code/Suit/SuitTool/Cron/Fabric.php on line 37','2024-07-06 17:40:02','2024-07-06 17:59:00','2024-07-06 17:59:02',NULL),(143812,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:01:00','2024-07-06 17:55:02','2024-07-06 18:01:00',NULL,NULL),(143813,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:02:00','2024-07-06 17:55:02','2024-07-06 18:02:00',NULL,NULL),(143814,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:03:00','2024-07-06 17:55:02','2024-07-06 18:03:00',NULL,NULL),(143815,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:04:00','2024-07-06 17:55:02','2024-07-06 18:04:00',NULL,NULL),(143816,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:05:00','2024-07-06 17:55:02','2024-07-06 18:05:00',NULL,NULL),(143817,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:06:00','2024-07-06 17:55:02','2024-07-06 18:06:00',NULL,NULL),(143818,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:07:00','2024-07-06 17:55:02','2024-07-06 18:07:00',NULL,NULL),(143819,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:08:00','2024-07-06 17:55:02','2024-07-06 18:08:00',NULL,NULL),(143820,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:09:00','2024-07-06 17:55:02','2024-07-06 18:09:00',NULL,NULL),(143821,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:10:00','2024-07-06 17:55:02','2024-07-06 18:10:00',NULL,NULL),(143822,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:11:00','2024-07-06 17:55:02','2024-07-06 18:11:00',NULL,NULL),(143823,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:12:00','2024-07-06 17:55:02','2024-07-06 18:12:00',NULL,NULL),(143824,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:13:00','2024-07-06 17:55:02','2024-07-06 18:13:00',NULL,NULL),(143825,'outdated_authentication_failures_cleanup','missed','Cron Job outdated_authentication_failures_cleanup is missed at 2024-07-06 18:14:00','2024-07-06 17:55:02','2024-07-06 18:14:00',NULL,NULL),(143829,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:01:00','2024-07-06 17:55:02','2024-07-06 18:01:00',NULL,NULL),(143830,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:02:00','2024-07-06 17:55:02','2024-07-06 18:02:00',NULL,NULL),(143831,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:03:00','2024-07-06 17:55:02','2024-07-06 18:03:00',NULL,NULL),(143832,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:04:00','2024-07-06 17:55:02','2024-07-06 18:04:00',NULL,NULL),(143833,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:05:00','2024-07-06 17:55:02','2024-07-06 18:05:00',NULL,NULL),(143834,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:06:00','2024-07-06 17:55:02','2024-07-06 18:06:00',NULL,NULL),(143835,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:07:00','2024-07-06 17:55:02','2024-07-06 18:07:00',NULL,NULL),(143836,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:08:00','2024-07-06 17:55:02','2024-07-06 18:08:00',NULL,NULL),(143837,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:09:00','2024-07-06 17:55:02','2024-07-06 18:09:00',NULL,NULL),(143838,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:10:00','2024-07-06 17:55:02','2024-07-06 18:10:00',NULL,NULL),(143839,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:11:00','2024-07-06 17:55:02','2024-07-06 18:11:00',NULL,NULL),(143840,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:12:00','2024-07-06 17:55:02','2024-07-06 18:12:00',NULL,NULL),(143841,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:13:00','2024-07-06 17:55:02','2024-07-06 18:13:00',NULL,NULL),(143842,'sales_grid_order_async_insert','missed','Cron Job sales_grid_order_async_insert is missed at 2024-07-06 18:14:00','2024-07-06 17:55:02','2024-07-06 18:14:00',NULL,NULL),(143844,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:01:00','2024-07-06 17:55:02','2024-07-06 18:01:00',NULL,NULL),(143845,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:02:00','2024-07-06 17:55:02','2024-07-06 18:02:00',NULL,NULL),(143846,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:03:00','2024-07-06 17:55:02','2024-07-06 18:03:00',NULL,NULL),(143847,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:04:00','2024-07-06 17:55:02','2024-07-06 18:04:00',NULL,NULL),(143848,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:05:00','2024-07-06 17:55:02','2024-07-06 18:05:00',NULL,NULL),(143849,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:06:00','2024-07-06 17:55:02','2024-07-06 18:06:00',NULL,NULL),(143850,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:07:00','2024-07-06 17:55:02','2024-07-06 18:07:00',NULL,NULL),(143851,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:08:00','2024-07-06 17:55:02','2024-07-06 18:08:00',NULL,NULL),(143852,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:09:00','2024-07-06 17:55:02','2024-07-06 18:09:00',NULL,NULL),(143853,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:10:00','2024-07-06 17:55:02','2024-07-06 18:10:00',NULL,NULL),(143854,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:11:00','2024-07-06 17:55:02','2024-07-06 18:11:00',NULL,NULL),(143855,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:12:00','2024-07-06 17:55:02','2024-07-06 18:12:00',NULL,NULL),(143856,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:13:00','2024-07-06 17:55:02','2024-07-06 18:13:00',NULL,NULL),(143857,'sales_grid_order_invoice_async_insert','missed','Cron Job sales_grid_order_invoice_async_insert is missed at 2024-07-06 18:14:00','2024-07-06 17:55:02','2024-07-06 18:14:00',NULL,NULL),(143859,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:01:00','2024-07-06 17:55:02','2024-07-06 18:01:00',NULL,NULL),(143860,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:02:00','2024-07-06 17:55:02','2024-07-06 18:02:00',NULL,NULL),(143861,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:03:00','2024-07-06 17:55:02','2024-07-06 18:03:00',NULL,NULL),(143862,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:04:00','2024-07-06 17:55:02','2024-07-06 18:04:00',NULL,NULL),(143863,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:05:00','2024-07-06 17:55:02','2024-07-06 18:05:00',NULL,NULL),(143864,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:06:00','2024-07-06 17:55:02','2024-07-06 18:06:00',NULL,NULL),(143865,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:07:00','2024-07-06 17:55:02','2024-07-06 18:07:00',NULL,NULL),(143866,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:08:00','2024-07-06 17:55:02','2024-07-06 18:08:00',NULL,NULL),(143867,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:09:00','2024-07-06 17:55:02','2024-07-06 18:09:00',NULL,NULL),(143868,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:10:00','2024-07-06 17:55:02','2024-07-06 18:10:00',NULL,NULL),(143869,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:11:00','2024-07-06 17:55:02','2024-07-06 18:11:00',NULL,NULL),(143870,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:12:00','2024-07-06 17:55:02','2024-07-06 18:12:00',NULL,NULL),(143871,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:13:00','2024-07-06 17:55:02','2024-07-06 18:13:00',NULL,NULL),(143872,'sales_grid_order_shipment_async_insert','missed','Cron Job sales_grid_order_shipment_async_insert is missed at 2024-07-06 18:14:00','2024-07-06 17:55:02','2024-07-06 18:14:00',NULL,NULL),